/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.swing.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.swing.PowerlinePanel;
import jmri.jmrix.powerline.swing.packetgen.Bundle;
import jmri.util.StringUtil;

public class SerialPacketGenPane
extends PowerlinePanel
implements SerialListener {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    JCheckBox checkBoxBinCmd = new JCheckBox();
    JTextField replyLenTextField = new JTextField(2);
    JCheckBox interlockButton = new JCheckBox(Bundle.getMessage("InterlockBoxLabel"));
    private SerialTrafficController tc = null;
    private SerialSystemConnectionMemo memo = null;

    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof SerialSystemConnectionMemo) {
            this.memo = (SerialSystemConnectionMemo)context;
            this.initComponents();
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.powerline.packetgen.PowerlinePacketGenPane";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append(Bundle.getMessage("DefaultTag"));
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public void initComponents(SerialSystemConnectionMemo memo) {
        this.memo = memo;
        this.tc = memo.getTrafficController();
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.interlockButton);
        this.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenPane.this.sendButtonActionPerformed(e);
            }
        });
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this.tc.sendSerialMessage(this.createPacket(input), this);
    }

    SerialMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        SerialMessage m = this.memo.getTrafficController().getSerialMessage(b.length);
        for (int i = 0; i < b.length; ++i) {
            m.setElement(i, b[i]);
        }
        m.setInterlocked(this.interlockButton.isSelected());
        return m;
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply r) {
    }
}

