/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pricom.downloader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jmri.jmrit.XmlFile;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.pricom.downloader.Bundle;
import jmri.jmrix.pricom.downloader.PdiFile;
import jmri.jmrix.purejavacomm.CommPortIdentifier;
import jmri.jmrix.purejavacomm.NoSuchPortException;
import jmri.jmrix.purejavacomm.PortInUseException;
import jmri.jmrix.purejavacomm.SerialPort;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderPane
extends JPanel {
    SerialPort activeSerialPort = null;
    Thread readerThread;
    DataInputStream serialStream = null;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Class is no longer active, no hardware with which to test fix")
    OutputStream ostream = null;
    final JComboBox<String> portBox = new JComboBox();
    final JButton openPortButton = new JButton();
    final JTextArea traffic = new JTextArea();
    final JFileChooser chooser = XmlFile.userFileChooser();
    final JButton fileButton;
    final JLabel inputFileName = new JLabel("");
    final JTextArea comment = new JTextArea();
    final JButton loadButton;
    final JProgressBar bar;
    final JLabel status = new JLabel("");
    PdiFile pdiFile;
    private static final Logger log = LoggerFactory.getLogger(LoaderPane.class);

    protected void addCommGUI() {
        this.portBox.setToolTipText(Bundle.getMessage("TipSelectPort"));
        this.portBox.setAlignmentX(0.0f);
        Vector<String> v = this.getPortNames();
        for (int i = 0; i < v.size(); ++i) {
            this.portBox.addItem(v.elementAt(i));
        }
        this.openPortButton.setText(Bundle.getMessage("ButtonOpen"));
        this.openPortButton.setToolTipText(Bundle.getMessage("TipOpenPort"));
        this.openPortButton.addActionListener(evt -> {
            try {
                this.openPortButtonActionPerformed(evt);
            }
            catch (UnsatisfiedLinkError ex) {
                log.error("Error while opening port. Did you select the right one?", (Throwable)ex);
            }
        });
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel(Bundle.getMessage("LabelSerialPort")));
        p1.add(this.portBox);
        p1.add(this.openPortButton);
        this.add(p1);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JLabel l = new JLabel(Bundle.getMessage("LabelTraffic"));
        l.setAlignmentX(0.0f);
        p.add(l);
        this.add(p);
        this.traffic.setEditable(false);
        this.traffic.setEnabled(true);
        this.traffic.setText("\n\n\n\n");
        this.add(this.traffic);
    }

    void openPortButtonActionPerformed(ActionEvent e) {
        log.info("Open button pushed");
        this.openPortButton.setEnabled(false);
        this.portBox.setEnabled(false);
        this.openPort((String)this.portBox.getSelectedItem(), "JMRI");
        this.status.setText(Bundle.getMessage("StatusSelectFile"));
        this.fileButton.setEnabled(true);
        this.fileButton.setToolTipText(Bundle.getMessage("TipFileEnabled"));
        log.info("Open button processing complete");
    }

    synchronized void sendBytes(byte[] bytes) {
        log.debug("Send {}: {}", (Object)bytes.length, (Object)StringUtil.hexStringFromBytes(bytes));
        try {
            int startbyte = 2;
            this.ostream.write(startbyte);
            block5: for (byte aByte : bytes) {
                switch (aByte) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 21: {
                        this.ostream.write(1);
                        this.ostream.write(aByte + 64);
                        continue block5;
                    }
                    default: {
                        this.ostream.write(aByte);
                    }
                }
            }
            int endbyte = 3;
            this.ostream.write(endbyte);
        }
        catch (IOException e) {
            log.error("Exception on output", (Throwable)e);
        }
    }

    void stopThread() {
        if (this.activeSerialPort != null) {
            this.activeSerialPort.close();
        }
    }

    public void dispose() {
        if (this.readerThread != null) {
            this.stopThread();
        }
        if (this.activeSerialPort != null) {
            this.activeSerialPort.close();
        }
        this.serialStream = null;
        this.ostream = null;
        this.activeSerialPort = null;
    }

    public Vector<String> getPortNames() {
        return AbstractSerialPortController.getActualPortNames();
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"}, justification="this is for skip-chars while loop: no matter how many, we're skipping")
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                this.handlePortBusy(p, portName);
                return "Port " + p + " already in use";
            }
            try {
                int speed = 9600;
                this.activeSerialPort.setSerialPortParams(speed, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.activeSerialPort.setRTS(true);
            this.activeSerialPort.setDTR(true);
            this.activeSerialPort.setFlowControlMode(0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = new DataInputStream(this.activeSerialPort.getInputStream());
            this.ostream = this.activeSerialPort.getOutputStream();
            int count = this.serialStream.available();
            log.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                this.serialStream.skip(count);
                count = this.serialStream.available();
            }
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
        }
        catch (IOException | RuntimeException | NoSuchPortException | UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    void handlePortBusy(PortInUseException p, String port) {
        log.error("Port {} in use, cannot open", (Object)port, (Object)p);
    }

    public LoaderPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.addCommGUI();
        this.add(new JSeparator());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.fileButton = new JButton(Bundle.getMessage("ButtonSelect"));
        this.fileButton.setEnabled(false);
        this.fileButton.setToolTipText(Bundle.getMessage("TipFileDisabled"));
        this.fileButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderPane.this.selectInputFile();
            }
        });
        p.add(this.fileButton);
        p.add(new JLabel(Bundle.getMessage("LabelInpFile")));
        p.add(this.inputFileName);
        this.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        JLabel l = new JLabel(Bundle.getMessage("LabelFileComment"));
        l.setAlignmentX(0.0f);
        p.add(l);
        this.add(p);
        this.comment.setEditable(false);
        this.comment.setEnabled(true);
        this.comment.setText("\n\n\n\n");
        this.add(this.comment);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.loadButton = new JButton(Bundle.getMessage("ButtonDownload"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        p.add(this.loadButton);
        this.loadButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderPane.this.doLoad();
            }
        });
        this.add(p);
        this.bar = new JProgressBar();
        this.add(this.bar);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.status.setText(Bundle.getMessage("StatusSelectPort"));
        this.status.setAlignmentX(0.0f);
        p.add(this.status);
        this.add(p);
    }

    void selectInputFile() {
        this.chooser.rescanCurrentDirectory();
        int retVal = this.chooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.inputFileName.setText(this.chooser.getSelectedFile().getPath());
        this.pdiFile = new PdiFile(this.chooser.getSelectedFile());
        try {
            this.pdiFile.open();
        }
        catch (IOException e) {
            log.error("Error opening file", (Throwable)e);
        }
        this.comment.setText(this.pdiFile.getComment());
        this.status.setText(Bundle.getMessage("StatusDoDownload"));
        this.loadButton.setEnabled(true);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadEnabled"));
        this.validate();
    }

    void doLoad() {
        this.status.setText(Bundle.getMessage("StatusRestartUnit"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadGoing"));
        this.readerThread = new LocalReader();
        this.readerThread.start();
    }

    long CRC_char(long crcin, byte ch) {
        long crc = crcin;
        crc = this.swap(crc);
        crc ^= (long)ch & 0xFFL;
        crc ^= (crc & 0xFFL) >> 4;
        crc = crc ^ this.swap(crc & 0xFFL) << 4 ^ (crc & 0xFFL) << 5;
        return crc &= 0xFFFFL;
    }

    long swap(long val) {
        long low = val & 0xFFL;
        long high = val >> 8 & 0xFFL;
        return low * 256L + high;
    }

    void CRC_block(byte[] buffer) {
        byte low;
        long crc = 0L;
        for (int r = 0; r < buffer.length - 2; ++r) {
            crc = this.CRC_char(crc, buffer[r]);
        }
        byte high = (byte)(crc >> 8 & 0xFFL);
        buffer[buffer.length - 2] = low = (byte)(crc & 0xFFL);
        buffer[buffer.length - 1] = high;
    }

    boolean isUploadReady(byte[] buffer) {
        if (buffer[0] != 31) {
            return false;
        }
        if (buffer[1] != 32) {
            return false;
        }
        if (buffer[2] != 99) {
            return false;
        }
        if (buffer[3] != 0) {
            return false;
        }
        return buffer[4] == 44 || buffer[4] == 45;
    }

    boolean isSendNext(byte[] buffer) {
        if (buffer[0] != 31) {
            return false;
        }
        if (buffer[1] != 32) {
            return false;
        }
        if (buffer[2] != 99) {
            return false;
        }
        if (buffer[3] != 0) {
            return false;
        }
        if (buffer[4] != 22) {
            return false;
        }
        log.debug("OK isSendNext");
        return true;
    }

    int getDataSize(byte[] buffer) {
        if (buffer[4] == 44) {
            return 64;
        }
        if (buffer[4] == 45) {
            return 128;
        }
        log.error("Bad length byte: {}", (Object)buffer[3]);
        return 64;
    }

    byte[] bootMessage() {
        byte[] buffer = new byte[]{99, 0, 0, 0, 0};
        this.CRC_block(buffer);
        return buffer;
    }

    class LocalReader
    extends Thread {
        static final int maxMsg = 80;
        byte[] inBuffer;
        int msgCount = 0;
        int msgSize = 64;
        boolean init = false;

        LocalReader() {
        }

        @Override
        public void run() {
            try {
                this.nibbleIncomingData();
            }
            catch (IOException e) {
                log.warn("nibble: Exception", (Throwable)e);
            }
            while (true) {
                try {
                    while (true) {
                        this.handleIncomingData();
                    }
                }
                catch (IOException e) {
                    log.warn("run: Exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        @SuppressFBWarnings(value={"SR_NOT_CHECKED"}, justification="this is for skip-chars while loop: no matter how many, we're skipping")
        void nibbleIncomingData() throws IOException {
            long nibbled = 0L;
            LoaderPane.this.serialStream = new DataInputStream(LoaderPane.this.activeSerialPort.getInputStream());
            LoaderPane.this.ostream = LoaderPane.this.activeSerialPort.getOutputStream();
            int count = LoaderPane.this.serialStream.available();
            while (count > 0) {
                LoaderPane.this.serialStream.skip(count);
                nibbled += (long)count;
                count = LoaderPane.this.serialStream.available();
            }
            log.debug("nibbled {} from input stream", (Object)nibbled);
        }

        void handleIncomingData() throws IOException {
            byte char1;
            int i;
            byte dataChar;
            StringBuffer mbuff = new StringBuffer();
            while ((dataChar = LoaderPane.this.serialStream.readByte()) != 2) {
                mbuff.append(dataChar);
                log.debug(" rcv char {}", (Object)dataChar);
                if (dataChar != 13) continue;
                SwingUtilities.invokeLater(new Notify(mbuff));
            }
            this.inBuffer = new byte[80];
            for (i = 0; i < 80 && (char1 = LoaderPane.this.serialStream.readByte()) != 3; ++i) {
                this.inBuffer[i] = char1;
            }
            log.debug("received {} bytes {}", (Object)(i + 1), (Object)StringUtil.hexStringFromBytes(this.inBuffer));
            this.nextMessage(this.inBuffer, i);
        }

        void nextMessage(byte[] buffer, int length) {
            if (LoaderPane.this.isUploadReady(buffer)) {
                this.msgSize = LoaderPane.this.getDataSize(buffer);
                this.init = true;
            }
            if (!this.init) {
                return;
            }
            if (!LoaderPane.this.isSendNext(buffer) && !LoaderPane.this.isUploadReady(buffer)) {
                log.debug("extra message, ignore");
                return;
            }
            Runnable r = this::updateGUI;
            SwingUtilities.invokeLater(r);
            byte[] outBuffer = LoaderPane.this.pdiFile.getNext(this.msgSize);
            if (outBuffer != null) {
                SwingUtilities.invokeLater(new Notify(outBuffer));
                LoaderPane.this.CRC_block(outBuffer);
                LoaderPane.this.sendBytes(outBuffer);
                return;
            }
            outBuffer = LoaderPane.this.bootMessage();
            LoaderPane.this.sendBytes(outBuffer);
            r = this::enableGUI;
            SwingUtilities.invokeLater(r);
            LoaderPane.this.stopThread();
        }

        void updateGUI() {
            log.debug("updateGUI with {} / {}", (Object)this.msgCount, (Object)(LoaderPane.this.pdiFile.length() / this.msgSize));
            if (!this.init) {
                return;
            }
            LoaderPane.this.status.setText(Bundle.getMessage("StatusDownloading"));
            ++this.msgCount;
            LoaderPane.this.bar.setValue(100 * this.msgCount * this.msgSize / LoaderPane.this.pdiFile.length());
        }

        void enableGUI() {
            log.debug("enableGUI");
            if (!this.init) {
                log.error("enableGUI with init false");
            }
            LoaderPane.this.loadButton.setEnabled(true);
            LoaderPane.this.loadButton.setToolTipText(Bundle.getMessage("TipLoadEnabled"));
            LoaderPane.this.status.setText(Bundle.getMessage("StatusDone"));
        }

        class Notify
        implements Runnable {
            final String message;

            Notify(StringBuffer b) {
                this.message = b.toString();
            }

            Notify(byte[] b) {
                this.message = StringUtil.hexStringFromBytes(b);
            }

            Notify(byte[] b, int length) {
                byte[] temp = new byte[length];
                for (int i = 0; i < length; ++i) {
                    temp[i] = b[i];
                }
                this.message = StringUtil.hexStringFromBytes(temp);
            }

            @Override
            public void run() {
                LoaderPane.this.traffic.setText(this.message);
            }
        }
    }
}

