/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pricom.pockettester;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.pricom.pockettester.Bundle;
import jmri.jmrix.pricom.pockettester.DataListener;
import jmri.jmrix.pricom.pockettester.MonitorAction;
import jmri.jmrix.pricom.pockettester.PacketTableAction;
import jmri.jmrix.pricom.pockettester.PacketTableFrame;
import jmri.jmrix.pricom.pockettester.StatusAction;
import jmri.jmrix.pricom.pockettester.StatusFrame;
import jmri.jmrix.purejavacomm.CommPortIdentifier;
import jmri.jmrix.purejavacomm.NoSuchPortException;
import jmri.jmrix.purejavacomm.PortInUseException;
import jmri.jmrix.purejavacomm.SerialPort;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends JmriJFrame {
    static DataSource existingInstance;
    SerialPort activeSerialPort = null;
    JLabel version = new JLabel("");
    JButton checkButton = new JButton(Bundle.getMessage("ButtonInit"));
    Thread readerThread;
    protected JComboBox<String> portBox = new JComboBox();
    protected JComboBox<String> speedBox = new JComboBox<String>(new String[]{"9600", "19200", "38400", "57600", "115200"});
    protected JButton openPortButton = new JButton();
    DataInputStream serialStream = null;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Class is no longer active, no hardware with which to test fix")
    OutputStream ostream = null;
    private static final Logger log;
    private final Vector<DataListener> listeners = new Vector();

    public static DataSource instance() {
        return existingInstance;
    }

    static void setInstance(DataSource source) {
        if (existingInstance != null) {
            log.error("Setting instance after it has already been set");
        } else {
            existingInstance = source;
        }
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("TitleSource"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.portBox.setToolTipText(Bundle.getMessage("TooltipSelectPort"));
        this.portBox.setAlignmentX(0.0f);
        Vector<String> v = this.getPortNames();
        for (int i = 0; i < v.size(); ++i) {
            this.portBox.addItem(v.elementAt(i));
        }
        this.speedBox.setToolTipText(Bundle.getMessage("TooltipSelectBaud"));
        this.speedBox.setAlignmentX(0.0f);
        this.speedBox.setSelectedItem("115200");
        this.openPortButton.setText(Bundle.getMessage("ButtonOpen"));
        this.openPortButton.setToolTipText(Bundle.getMessage("TooltipOpen"));
        this.openPortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    DataSource.this.openPortButtonActionPerformed(evt);
                }
                catch (UnsatisfiedLinkError ex) {
                    log.error("Error while opening port.  Did you select the right one?", (Throwable)ex);
                }
            }
        });
        this.getContentPane().add(new JSeparator());
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel(Bundle.getMessage("LabelSerialPort")));
        p1.add(this.portBox);
        p1.add(new JLabel(Bundle.getMessage("LabelSpeed")));
        p1.add(this.speedBox);
        p1.add(this.openPortButton);
        this.getContentPane().add(p1);
        DataSource.setInstance(this);
        this.pack();
    }

    void addUserGui() {
        this.getContentPane().add(new JSeparator());
        JPanel p2 = new JPanel();
        p2.add(this.checkButton);
        this.checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSource.this.sendBytes(new byte[]{71});
                DataSource.this.sendBytes(new byte[]{70});
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        ButtonGroup g = new ButtonGroup();
        JRadioButton b = new JRadioButton(Bundle.getMessage("ButtonShowAll"));
        g.add(b);
        p.add(b);
        b.setSelected(true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSource.this.sendBytes(new byte[]{70});
            }
        });
        b = new JRadioButton(Bundle.getMessage("ButtonShowAcc"));
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSource.this.sendBytes(new byte[]{65});
            }
        });
        p2.add(p);
        b = new JRadioButton(Bundle.getMessage("ButtonShowMobile"));
        g.add(b);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSource.this.sendBytes(new byte[]{77});
            }
        });
        p2.add(p);
        JButton b2 = new JButton(Bundle.getMessage("ButtonGetVersion"));
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSource.this.version.setText(Bundle.getMessage("LabelWaitVersion"));
                DataSource.this.sendBytes(new byte[]{86});
            }
        });
        p2.add(b2);
        this.getContentPane().add(p2);
        this.version = new JLabel(Bundle.getMessage("LabelNoVersion", Bundle.getMessage("ButtonGetVersion")));
        JPanel p3 = new JPanel();
        p3.add(this.version);
        this.getContentPane().add(p3);
        this.getContentPane().add(new JSeparator());
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, 0));
        p4.add(new JLabel(Bundle.getMessage("LabelToOpen")));
        AbstractAction a = new MonitorAction(){

            @Override
            public void connect(DataListener l) {
                DataSource.this.addListener(l);
            }
        };
        JButton b3 = new JButton((String)a.getValue("Name"));
        b3.addActionListener(a);
        p4.add(b3);
        PacketTableAction p5 = new PacketTableAction(){

            @Override
            public void connect(DataListener l) {
                DataSource.this.addListener(l);
                if (l instanceof PacketTableFrame) {
                    ((PacketTableFrame)l).setSource(DataSource.this);
                }
            }
        };
        b3 = new JButton((String)p5.getValue("Name"));
        b3.addActionListener(p5);
        p4.add(b3);
        a = new StatusAction(){

            @Override
            public void connect(StatusFrame l) {
                DataSource.this.addListener(l);
                l.setSource(DataSource.this);
            }
        };
        b3 = new JButton((String)a.getValue("Name"));
        b3.addActionListener(a);
        p4.add(b3);
        this.getContentPane().add(p4);
        this.pack();
    }

    synchronized void sendBytes(byte[] bytes) {
        try {
            for (int i = 0; i < bytes.length - 1; ++i) {
                this.ostream.write(bytes[i]);
                this.wait(3L);
            }
            byte endbyte = bytes[bytes.length - 1];
            this.ostream.write(endbyte);
        }
        catch (IOException e) {
            log.error("Exception on output", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Interrupted output", (Throwable)e);
        }
    }

    void openPortButtonActionPerformed(ActionEvent e) {
        log.info("Open button pushed");
        this.openPortButton.setEnabled(false);
        this.portBox.setEnabled(false);
        this.speedBox.setEnabled(false);
        this.openPort((String)this.portBox.getSelectedItem(), "JMRI");
        this.readerThread = new Thread(new Reader());
        this.readerThread.start();
        log.info("Open button processing complete");
        this.addUserGui();
    }

    @Override
    public void dispose() {
        if (this.activeSerialPort != null) {
            this.activeSerialPort.close();
        }
        this.serialStream = null;
        this.ostream = null;
        this.activeSerialPort = null;
        super.dispose();
    }

    public Vector<String> getPortNames() {
        return AbstractSerialPortController.getActualPortNames();
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"}, justification="this is for skip-chars while loop: no matter how many, we're skipping")
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                this.handlePortBusy(p, portName);
                return "Port " + p + " in use already";
            }
            try {
                int speed = 115200;
                speed = Integer.parseInt((String)this.speedBox.getSelectedItem());
                this.activeSerialPort.setSerialPortParams(speed, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.activeSerialPort.setRTS(true);
            this.activeSerialPort.setDTR(true);
            this.activeSerialPort.setFlowControlMode(0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = new DataInputStream(this.activeSerialPort.getInputStream());
            this.ostream = this.activeSerialPort.getOutputStream();
            this.sendBytes(new byte[]{103});
            int count = this.serialStream.available();
            log.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                this.serialStream.skip(count);
                count = this.serialStream.available();
            }
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
        }
        catch (IOException ex) {
            log.error("Unexpected I/O exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        catch (NoSuchPortException ex) {
            log.error("No such port while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        catch (UnsupportedCommOperationException ex) {
            log.error("Unexpected comm exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    void handlePortBusy(PortInUseException p, String port) {
        log.error("Port {} in use, cannot open", (Object)port, (Object)p);
    }

    public synchronized void addListener(DataListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public synchronized void removeListener(DataListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextLine(String s) {
        Vector<DataListener> v;
        if (s.startsWith("PRICOM Design DCC")) {
            this.version.setText(s);
            return;
        }
        DataSource dataSource = this;
        synchronized (dataSource) {
            v = new Vector<DataListener>(this.listeners);
        }
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            DataListener client = v.elementAt(i);
            client.asciiFormattedMessage(s);
        }
    }

    static {
        log = LoggerFactory.getLogger(DataSource.class);
    }

    class Reader
    implements Runnable {
        static final int maxMsg = 200;
        StringBuffer msg;
        String msgString;

        Reader() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.handleIncomingData();
                    }
                }
                catch (IOException e) {
                    log.warn("run: Exception: {}", (Object)e.toString());
                    continue;
                }
                break;
            }
        }

        void handleIncomingData() throws IOException {
            char char1;
            this.msg = new StringBuffer(200);
            for (int i = 0; i < 200 && (char1 = (char)DataSource.this.serialStream.readByte()) != '\n'; ++i) {
                if (char1 == '\r') continue;
                this.msg.append(char1);
            }
            this.msg.append("\n");
            this.msgString = this.msg.toString();
            Runnable r = new Runnable(){
                String msgForLater;
                {
                    this.msgForLater = Reader.this.msgString;
                }

                @Override
                public void run() {
                    DataSource.this.nextLine(this.msgForLater);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }
}

