/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pricom.pockettester;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.pricom.pockettester.Bundle;
import jmri.jmrix.pricom.pockettester.DataListener;
import jmri.jmrix.pricom.pockettester.DataSource;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusFrame
extends JmriJFrame
implements DataListener {
    Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusFrame.this.sendRequest();
        }
    });
    JTabbedPane tabPane = new JTabbedPane();
    Hashtable<String, JLabel> displayHash = new Hashtable();
    Hashtable<String, String> formatHash = new Hashtable();
    DataSource source = null;
    private static final Logger log = LoggerFactory.getLogger(StatusFrame.class);

    public StatusFrame() {
        super(Bundle.getMessage("TitleStatus"));
    }

    @Override
    public void initComponents() {
        this.getContentPane().add(this.tabPane);
        int numAutoPane = Integer.parseInt(Bundle.getMessage("CSNumAutoPanes"));
        for (int i = 0; i < numAutoPane; ++i) {
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(0, 2));
            this.tabPane.addTab(Bundle.getMessage("CS" + i + "Title"), p);
            int numVars = Integer.parseInt(Bundle.getMessage("CS" + i + "NumVars"));
            for (int j = 0; j < numVars; ++j) {
                p.add(new JLabel(Bundle.getMessage("CS" + i + "Var" + j + "Name")));
                JLabel val = new JLabel("-----");
                this.displayHash.put(Bundle.getMessage("CS" + i + "Var" + j + "ID"), val);
                this.formatHash.put(Bundle.getMessage("CS" + i + "Var" + j + "ID"), Bundle.getMessage("CS" + i + "Var" + j + "Format"));
                p.add(val);
            }
        }
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StatusFrame.this.sendRequest();
            }
        });
        this.pack();
    }

    protected String title() {
        return Bundle.getMessage("TitleStatus");
    }

    @Override
    public void asciiFormattedMessage(String input) {
        Object m = input + " ";
        if (!((String)m).substring(0, 1).equals(" ")) {
            return;
        }
        if (!((String)m).substring(3, 4).equals("=")) {
            return;
        }
        int addOne = 0;
        if (((String)m).substring(4, 5).equals("\u0000")) {
            addOne = 1;
        }
        while (((String)m).length() >= 14 + addOne) {
            String id = ((String)m).substring(1, 3);
            String value = ((String)m).substring(4 + addOne, 14 + addOne);
            if (log.isDebugEnabled()) {
                log.debug("set var {}:{}", (Object)id, (Object)value);
            }
            JLabel label = this.displayHash.get(id);
            String format = this.formatHash.get(id);
            if (label != null) {
                label.setText(this.convertValue(value, format));
            }
            m = ((String)m).substring(14 + addOne);
        }
    }

    protected String convertValue(String val, String format) {
        if (format.equals("address")) {
            int address = Integer.parseInt(val);
            if (address >= 32768) {
                return address - 32768 + " (long)";
            }
            return address + " (short)";
        }
        if (format.equals("msec")) {
            return val.substring(0, 5) + "." + val.substring(5) + " msec";
        }
        if (format.equals("none")) {
            return val;
        }
        return val + " (bad format)";
    }

    private void sendRequest() {
        int i = this.tabPane.getSelectedIndex();
        String prompt = Bundle.getMessage("CS" + i + "PromptChar");
        log.debug("send {} for pane {}", (Object)prompt, (Object)i);
        if (this.source == null) {
            log.error("DataSource should not be null in sendRequest");
            this.timer.stop();
            return;
        }
        this.source.sendBytes(prompt.getBytes());
    }

    public void setSource(DataSource s) {
        this.source = s;
        this.timer.setRepeats(true);
        this.timer.start();
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
    }
}

