/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.purejavacomm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.SerialPort;
import jmri.jmrix.purejavacomm.SerialPortEvent;
import jmri.jmrix.purejavacomm.SerialPortEventListener;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPort {
    public static final int DATABITS_8 = 8;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    private jmri.jmrix.SerialPort _serialPort;
    private SerialPortEventListener _eventListener;
    private boolean _threadStarted = false;
    private Thread _inputThread;
    private volatile boolean _notifyOnDataAvailable;
    private static final Logger log = LoggerFactory.getLogger(SerialPort.class);

    public SerialPort(jmri.jmrix.SerialPort serialPort) {
        this._serialPort = serialPort;
        Runnable runnable = () -> {
            int TIMEOUT = Integer.getInteger("purejavacomm.pollperiod", 10);
            InputStream inputStream = this._serialPort.getInputStream();
            try {
                while (true) {
                    if (this._notifyOnDataAvailable && this._eventListener != null && inputStream.available() > 0) {
                        this._eventListener.serialEvent(new SerialPortEvent(this, 1, false, true));
                        continue;
                    }
                    Thread.sleep(TIMEOUT);
                }
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted");
            }
            catch (IOException e) {
                log.error("An IO error occurred", (Throwable)e);
            }
        };
        this._inputThread = ThreadingUtil.newThread(runnable, "jmri.jmrix.purejavacomm.SerialPort");
        this._inputThread.setDaemon(true);
    }

    private void setParity(int parity) {
        switch (parity) {
            case 0: {
                this._serialPort.setParity(SerialPort.Parity.NONE);
                break;
            }
            case 2: {
                this._serialPort.setParity(SerialPort.Parity.EVEN);
                break;
            }
            case 1: {
                this._serialPort.setParity(SerialPort.Parity.ODD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown parity: " + Integer.toString(parity));
            }
        }
    }

    public void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        this._serialPort.setBaudRate(baudRate);
        this._serialPort.setNumDataBits(dataBits);
        this._serialPort.setNumStopBits(stopBits);
        this.setParity(parity);
    }

    public void addEventListener(SerialPortEventListener listener) throws TooManyListenersException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this._eventListener != null) {
            throw new TooManyListenersException();
        }
        this._eventListener = listener;
        if (!this._threadStarted) {
            this._threadStarted = true;
            this._inputThread.start();
        }
    }

    public void notifyOnDataAvailable(boolean value) {
        this._notifyOnDataAvailable = value;
    }

    public void setFlowControlMode(int mode) throws UnsupportedCommOperationException {
        switch (mode) {
            case 0: {
                this._serialPort.setFlowControl(AbstractSerialPortController.FlowControl.NONE);
                break;
            }
            case 3: {
                this._serialPort.setFlowControl(AbstractSerialPortController.FlowControl.RTSCTS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown flow control mode: " + Integer.toString(mode));
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        return this._serialPort.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._serialPort.getOutputStream();
    }

    public int getBaudRate() {
        return this._serialPort.getBaudRate();
    }

    public void setDTR(boolean value) {
        if (value) {
            this._serialPort.setDTR();
        } else {
            this._serialPort.clearDTR();
        }
    }

    public void setRTS(boolean value) {
        if (value) {
            this._serialPort.setRTS();
        } else {
            this._serialPort.clearRTS();
        }
    }

    public boolean isDTR() {
        return this._serialPort.getDTR();
    }

    public boolean isRTS() {
        return this._serialPort.getRTS();
    }

    public boolean isDSR() {
        return this._serialPort.getDSR();
    }

    public boolean isCTS() {
        return this._serialPort.getCTS();
    }

    public boolean isCD() {
        return this._serialPort.getDCD();
    }

    public boolean isRI() {
        return this._serialPort.getRI();
    }

    public boolean isReceiveTimeoutEnabled() {
        return false;
    }

    public int getReceiveTimeout() {
        return 0;
    }

    public void close() {
        this._serialPort.closePort();
    }
}

