/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.qsi;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.qsi.QsiListener;
import jmri.jmrix.qsi.QsiMessage;
import jmri.jmrix.qsi.QsiReply;
import jmri.jmrix.qsi.QsiSystemConnectionMemo;
import jmri.jmrix.qsi.QsiTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QsiProgrammer
extends AbstractProgrammer
implements QsiListener {
    private QsiSystemConnectionMemo _memo = null;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    static final int WAITRESULT = 4;
    static final int WAITRESETSTATUS = 6;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    QsiTrafficController _controller = null;
    private static final Logger log = LoggerFactory.getLogger(QsiProgrammer.class);

    protected QsiProgrammer(QsiSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.DIRECTBITMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        this.controller().sendQsiMessage(QsiMessage.getWriteCV(CV, val, this.getMode()), this);
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        this.startShortTimer();
        this.controller().sendQsiMessage(QsiMessage.getReadCV(CV, this.getMode()), this);
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void message(QsiMessage m) {
        log.error("message received unexpectedly: {}", (Object)m);
    }

    @Override
    public synchronized void reply(QsiReply m) {
        if (this.progState == 0) {
            log.debug("reply in NOTPROGRAMMING state");
            return;
        }
        if (this.progState == 2) {
            log.debug("reply in COMMANDSENT state");
            this.progState = 4;
            this.startLongTimer();
        } else if (this.progState == 4) {
            if (log.isDebugEnabled()) {
                log.debug("reply in WAITRESULT state");
            }
            this.stopTimer();
            this.controller().sendQsiMessage(QsiReply.getAck(m), null);
            this.progState = 0;
            if (m.getElement(4) != 0) {
                log.debug("handle non-zero status in reply {}", (Object)m);
                this.progState = 6;
                this.startShortTimer();
                this.controller().sendQsiMessage(QsiMessage.getClearStatus(), this);
            } else {
                if (this._progRead) {
                    this._val = m.value();
                }
                this.notifyProgListenerEnd(this._val, 0);
            }
        } else if (this.progState == 6) {
            log.debug("reply in WAITRESETSTATUS state");
            this.progState = 0;
            this.stopTimer();
            this.notifyProgListenerEnd(-1, 2);
        } else {
            log.debug("reply in un-decoded state");
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            log.debug("timeout!");
            this.progState = 0;
            this.controller().sendQsiMessage(QsiMessage.getClearStatus(), null);
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }

    protected QsiTrafficController controller() {
        if (this._controller == null) {
            this._controller = this._memo.getQsiTrafficController();
        }
        return this._controller;
    }
}

