/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.qsi;

import jmri.InstanceManager;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.qsi.QsiMessage;
import jmri.jmrix.qsi.QsiSystemConnectionMemo;
import jmri.jmrix.qsi.QsiTrafficController;
import jmri.util.StringUtil;

public class QsiReply
extends AbstractMessage {
    static final int MAXREPLYLENGTH = 200;
    public static final int MAXSIZE = 515;
    private boolean _isBoot = false;

    public QsiReply() {
        super(200);
        this._isBoot = false;
        this._nDataChars = 0;
    }

    public QsiReply(QsiReply m) {
        super(m);
        this._isBoot = m._isBoot;
    }

    public QsiReply(String s) {
        super(s);
    }

    public QsiReply(String s, boolean b) {
        super(s);
        this._isBoot = b;
    }

    public void setOpCode(int i) {
        this._dataChars[0] = (char)i;
    }

    public int getOpCode() {
        return this._dataChars[0];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
        this._nDataChars = Math.max(this._nDataChars, n + 1);
    }

    public static QsiMessage getAck(QsiReply r) {
        QsiMessage m = new QsiMessage(1);
        m.setElement(0, r.getElement(1));
        return m;
    }

    public boolean strip() {
        int[] tmp = new int[this._nDataChars];
        int j = 0;
        this._isBoot = true;
        if (this._dataChars[0] != 15) {
            return false;
        }
        if (this._dataChars[1] != 15) {
            return false;
        }
        if (this._dataChars[this._nDataChars - 1] != 4) {
            return false;
        }
        for (int i = 2; i < this._nDataChars - 1; ++i) {
            if (this._dataChars[i] == 5) {
                ++i;
            }
            tmp[j++] = this._dataChars[i];
        }
        System.arraycopy(tmp, 0, this._dataChars, 0, j);
        this._nDataChars = j;
        return true;
    }

    public boolean getChecksum() {
        int checksum = 0;
        for (int i = 0; i < this._nDataChars; ++i) {
            checksum += this._dataChars[i] & 0xFF;
        }
        --this._nDataChars;
        return (checksum & 0xFF) == 0;
    }

    @Override
    public String toString() {
        QsiSystemConnectionMemo memo = InstanceManager.getDefault(QsiSystemConnectionMemo.class);
        return this.toString(memo.getQsiTrafficController());
    }

    public String toString(QsiTrafficController controller) {
        StringBuilder s = new StringBuilder();
        if (this._dataChars == null) {
            return "<none>";
        }
        if (controller == null || controller.isSIIBootMode()) {
            for (int i = 0; i < this._nDataChars; ++i) {
                s.append(StringUtil.twoHexFromInt(this._dataChars[i]));
                s.append(" ");
            }
        } else {
            for (int i = 0; i < this._nDataChars; ++i) {
                s.append("<");
                s.append(this._dataChars[i]);
                s.append(">");
            }
        }
        return new String(s);
    }

    public int value() {
        return this.getElement(5) & 0xFF;
    }

    int match(String s) {
        String rep = new String(this._dataChars, 0, this._nDataChars);
        return rep.indexOf(s);
    }

    int skipWhiteSpace(int index) {
        while (index < this.getNumDataElements() - 1 && (char)this.getElement(index) <= ' ') {
            ++index;
        }
        return index;
    }

    int skipEqual(int index) {
        int len = "= h".length();
        if (this.getNumDataElements() >= index + len - 1 && '=' == (char)this.getElement(index) && ' ' == (char)this.getElement(index + 1) && 'h' == (char)this.getElement(index + 2)) {
            index += len;
        }
        return index;
    }
}

