/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.qsi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jmri.jmrix.qsi.QsiInterface;
import jmri.jmrix.qsi.QsiListener;
import jmri.jmrix.qsi.QsiMessage;
import jmri.jmrix.qsi.QsiPortController;
import jmri.jmrix.qsi.QsiReply;
import jmri.jmrix.qsi.serialdriver.SerialDriverAdapter;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QsiTrafficController
implements QsiInterface,
Runnable {
    protected Vector<QsiListener> cmdListeners = new Vector();
    QsiListener lastSender = null;
    public static final int NORMAL = 0;
    public static final int SIIBOOTMODE = 1;
    public static final int V4BOOTMODE = 2;
    private int qsiState = 0;
    private QsiPortController controller = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private static final Logger log = LoggerFactory.getLogger(QsiTrafficController.class);

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    @Override
    public synchronized void addQsiListener(QsiListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.cmdListeners.contains(l)) {
            this.cmdListeners.addElement(l);
        }
    }

    @Override
    public synchronized void removeQsiListener(QsiListener l) {
        if (this.cmdListeners.contains(l)) {
            this.cmdListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessage(QsiMessage m, QsiListener notMe) {
        Vector v;
        QsiTrafficController qsiTrafficController = this;
        synchronized (qsiTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            QsiListener client = (QsiListener)v.elementAt(i);
            if (notMe == client) continue;
            log.debug("notify client: {}", (Object)client);
            try {
                client.message(m);
                continue;
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}", (Object)client, (Object)e);
            }
        }
    }

    public int getQsiState() {
        return this.qsiState;
    }

    public void setQsiState(int s) {
        this.qsiState = s;
        if (this.controller instanceof SerialDriverAdapter) {
            if (s == 2) {
                ((SerialDriverAdapter)this.controller).setHandshake(3);
            } else {
                ((SerialDriverAdapter)this.controller).setHandshake(0);
            }
            log.debug("Setting qsiState {}", (Object)s);
        }
    }

    public boolean isNormalMode() {
        return this.qsiState == 0;
    }

    public boolean isSIIBootMode() {
        return this.qsiState == 1;
    }

    public boolean isV4BootMode() {
        return this.qsiState == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReply(QsiReply r) {
        Vector v;
        QsiTrafficController qsiTrafficController = this;
        synchronized (qsiTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            QsiListener client = (QsiListener)v.elementAt(i);
            log.debug("notify client: {}", (Object)client);
            try {
                if (this.lastSender == client) continue;
                client.reply(r);
                continue;
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}", (Object)client, (Object)e);
            }
        }
        if (this.lastSender != null) {
            this.lastSender.reply(r);
        }
    }

    @Override
    public void sendQsiMessage(QsiMessage m, QsiListener reply) {
        log.debug("sendQsiMessage message: [{}]", (Object)m);
        this.lastSender = reply;
        this.notifyMessage(m, reply);
        int len = m.getNumDataElements();
        int cr = 0;
        int start = 0;
        if (this.isSIIBootMode()) {
            cr = 1;
            start = 0;
        } else {
            cr = 3;
            start = 1;
        }
        byte[] msg = new byte[len + cr];
        byte crc = 0;
        for (int i = 0; i < len; ++i) {
            msg[i + start] = (byte)m.getElement(i);
            crc = (byte)(crc ^ msg[i + start]);
        }
        if (this.isSIIBootMode()) {
            msg[len] = 13;
        } else {
            msg[0] = 83;
            msg[len + cr - 2] = crc;
            msg[len + cr - 1] = 69;
        }
        try {
            if (this.ostream != null) {
                if (log.isDebugEnabled()) {
                    log.debug("write message: {}", (Object)StringUtil.hexStringFromBytes(msg));
                }
                this.ostream.write(msg);
            } else {
                log.warn("sendMessage: no connection established");
            }
        }
        catch (Exception e) {
            log.warn("sendMessage: Exception: {}", (Object)e.toString());
        }
    }

    public void connectPort(QsiPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(QsiPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortController");
        }
        this.controller = null;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.handleOneIncomingReply();
                }
            }
            catch (IOException e) {
                log.warn("run: Exception: {}", (Object)e.toString());
                continue;
            }
            break;
        }
    }

    void handleOneIncomingReply() throws IOException {
        int i;
        QsiReply msg = new QsiReply();
        for (i = 0; i < 515; ++i) {
            byte char1 = this.istream.readByte();
            if (log.isDebugEnabled()) {
                log.debug("   Rcv char: {}", (Object)StringUtil.twoHexFromInt(char1));
            }
            msg.setElement(i, char1);
            if (this.endReply(msg)) break;
        }
        log.debug("dispatch reply of length {}", (Object)i);
        final QsiReply thisMsg = msg;
        final QsiTrafficController thisTc = this;
        Runnable r = new Runnable(){
            QsiReply msgForLater;
            QsiTrafficController myTc;
            {
                this.msgForLater = thisMsg;
                this.myTc = thisTc;
            }

            @Override
            public void run() {
                log.debug("Delayed notify starts");
                this.myTc.notifyReply(this.msgForLater);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    boolean endReply(QsiReply msg) {
        return this.endNormalReply(msg);
    }

    boolean endNormalReply(QsiReply msg) {
        int num = msg.getNumDataElements();
        if (num >= 3) {
            int ptr = num - 1;
            return msg.getElement(ptr) == 69;
        }
        return false;
    }
}

