/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractStreamPortController;
import jmri.jmrix.rfid.Bundle;
import jmri.jmrix.rfid.RfidInterface;
import jmri.jmrix.rfid.RfidListener;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidProtocol;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.generic.standalone.StandaloneReporterManager;
import jmri.jmrix.rfid.generic.standalone.StandaloneSensorManager;
import jmri.jmrix.rfid.generic.standalone.StandaloneTrafficController;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorReporterManager;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorSensorManager;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorTrafficController;
import jmri.jmrix.rfid.protocol.coreid.CoreIdRfidProtocol;
import jmri.jmrix.rfid.protocol.em18.Em18RfidProtocol;
import jmri.jmrix.rfid.protocol.olimex.OlimexRfid1356mifareProtocol;
import jmri.jmrix.rfid.protocol.olimex.OlimexRfidProtocol;
import jmri.jmrix.rfid.protocol.parallax.ParallaxRfidProtocol;
import jmri.jmrix.rfid.protocol.seeedstudio.SeeedStudioRfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RfidStreamPortController
extends AbstractStreamPortController
implements RfidInterface {
    private static final Logger log = LoggerFactory.getLogger(RfidStreamPortController.class);

    public RfidStreamPortController(DataInputStream in, DataOutputStream out, String pname) {
        super(new RfidSystemConnectionMemo(), in, out, pname);
        this.option1Name = "Adapter";
        this.option2Name = "Concentrator-Range";
        this.option3Name = "Protocol";
        this.option4Name = "Device";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionAdapter"), new String[]{"Generic Stand-alone", "MERG Concentrator"}, false));
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionConcentratorRange"), new String[]{"A-H", "I-P"}, false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), new String[]{"CORE-ID", "Olimex", "Parallax", "SeeedStudio", "EM-18"}, false));
        this.options.put(this.option4Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionDeviceType"), new String[]{"MOD-RFID125", "MOD-RFID1356MIFARE"}, false));
        this.manufacturerName = "RFID";
    }

    public RfidStreamPortController() {
        super(new RfidSystemConnectionMemo());
        this.option1Name = "Adapter";
        this.option2Name = "Concentrator-Range";
        this.option3Name = "Protocol";
        this.option4Name = "Device";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionAdapter"), new String[]{"Generic Stand-alone", "MERG Concentrator"}, false));
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionConcentratorRange"), new String[]{"A-H", "I-P"}, false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), new String[]{"CORE-ID", "Olimex", "Parallax", "SeeedStudio", "EM-18"}, false));
        this.options.put(this.option4Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionDeviceType"), new String[]{"MOD-RFID125", "MOD-RFID1356MIFARE"}, false));
        this.manufacturerName = "RFID";
    }

    @Override
    public void configure() {
        RfidProtocol protocol;
        RfidTrafficController control;
        String opt1;
        log.debug("configure() called.");
        switch (opt1 = this.getOptionState(this.option1Name)) {
            case "Generic Stand-alone": {
                log.debug("Create Generic Standalone SpecificTrafficController");
                control = new StandaloneTrafficController(this.getSystemConnectionMemo());
                this.getSystemConnectionMemo().setRfidTrafficController(control);
                this.getSystemConnectionMemo().configureManagers(new StandaloneSensorManager(this.getSystemConnectionMemo()), new StandaloneReporterManager(this.getSystemConnectionMemo()));
                break;
            }
            case "MERG Concentrator": {
                log.debug("Create MERG Concentrator SpecificTrafficController");
                control = new ConcentratorTrafficController(this.getSystemConnectionMemo(), this.getOptionState(this.option2Name));
                this.getSystemConnectionMemo().configureManagers(new ConcentratorSensorManager(this.getSystemConnectionMemo()), new ConcentratorReporterManager(this.getSystemConnectionMemo()));
                break;
            }
            default: {
                log.warn("adapter option {} defaults to Generic Stand-alone", (Object)opt1);
                control = new StandaloneTrafficController(this.getSystemConnectionMemo());
                this.getSystemConnectionMemo().configureManagers(new StandaloneSensorManager(this.getSystemConnectionMemo()), new StandaloneReporterManager(this.getSystemConnectionMemo()));
            }
        }
        String opt3 = this.getOptionState(this.option3Name);
        String opt4 = this.getOptionState(this.option4Name);
        if (opt1.equals("MERG Concentrator")) {
            String opt2;
            log.info("set protocol to CORE-ID");
            switch (opt2 = this.getOptionState(this.option2Name)) {
                case "A-H": {
                    log.info("set concentrator range to 'A-H' at position 1");
                    protocol = new CoreIdRfidProtocol('A', 'H', 1);
                    break;
                }
                case "I-P": {
                    log.info("set concentrator range to 'I-P' at position 1");
                    protocol = new CoreIdRfidProtocol('I', 'P', 1);
                    break;
                }
                default: {
                    log.warn("concentrator range '{}' not supported - default to no concentrator", (Object)opt2);
                    protocol = new CoreIdRfidProtocol();
                    break;
                }
            }
        } else {
            switch (opt3) {
                case "CORE-ID": {
                    log.info("set protocol to CORE-ID");
                    protocol = new CoreIdRfidProtocol();
                    break;
                }
                case "Olimex": {
                    if (opt4.equals("MOD-RFID1356MIFARE")) {
                        log.info("set protocol for Olimex MOD-RFID1356MIFARE");
                        protocol = new OlimexRfid1356mifareProtocol();
                        break;
                    }
                    log.info("set protocol for Olimex MOD-RFID125");
                    protocol = new OlimexRfidProtocol();
                    break;
                }
                case "Parallax": {
                    log.info("set protocol to Parallax");
                    protocol = new ParallaxRfidProtocol();
                    break;
                }
                case "SeeedStudio": {
                    log.info("set protocol to SeeedStudio");
                    protocol = new SeeedStudioRfidProtocol();
                    break;
                }
                case "EM-18": {
                    log.info("set protocol to EM-18");
                    protocol = new Em18RfidProtocol();
                    break;
                }
                default: {
                    log.warn("protocol option {} defaults to CORE-ID", (Object)opt3);
                    protocol = new CoreIdRfidProtocol();
                }
            }
        }
        this.getSystemConnectionMemo().setProtocol(protocol);
        this.getSystemConnectionMemo().setRfidTrafficController(control);
        control.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers(new StandaloneSensorManager(this.getSystemConnectionMemo()), new StandaloneReporterManager(this.getSystemConnectionMemo()));
        control.connectPort(this);
    }

    @Override
    public boolean status() {
        return true;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void addRfidListener(RfidListener l) {
        this.getSystemConnectionMemo().getTrafficController().addRfidListener(l);
    }

    @Override
    public void removeRfidListener(RfidListener l) {
        this.getSystemConnectionMemo().getTrafficController().removeRfidListener(l);
    }

    @Override
    public void sendRfidMessage(RfidMessage m, RfidListener l) {
        this.getSystemConnectionMemo().getTrafficController().sendRfidMessage(m, l);
    }

    @Override
    public RfidSystemConnectionMemo getSystemConnectionMemo() {
        return (RfidSystemConnectionMemo)super.getSystemConnectionMemo();
    }
}

