/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import jmri.IdTag;
import jmri.jmrix.rfid.RfidSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutRfidSensor
extends RfidSensor {
    private static final int TIMEOUT = 1000;
    private long whenLastSensed = 0L;
    private transient TimeoutThread timeoutThread = null;
    private final boolean logDebug = log.isDebugEnabled();
    private static final Logger log = LoggerFactory.getLogger(TimeoutRfidSensor.class);

    public TimeoutRfidSensor(String systemName) {
        super(systemName);
    }

    public TimeoutRfidSensor(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public void notify(IdTag t) {
        super.notify(t);
        this.whenLastSensed = System.currentTimeMillis();
        if (this.timeoutThread == null) {
            this.timeoutThread = new TimeoutThread();
            this.timeoutThread.start();
        }
    }

    private void cleanUpTimeout() {
        if (this.logDebug) {
            log.debug("Cleanup timeout thread for {}", (Object)this.mSystemName);
        }
        this.timeoutThread = null;
    }

    private class TimeoutThread
    extends Thread {
        TimeoutThread() {
            this.setName("Timeout-" + TimeoutRfidSensor.this.mSystemName);
        }

        @Override
        public void run() {
            while (TimeoutRfidSensor.this.whenLastSensed + 1000L > System.currentTimeMillis()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TimeoutRfidSensor.super.notify(null);
            if (TimeoutRfidSensor.this.logDebug) {
                log.debug("Timeout-{}", (Object)TimeoutRfidSensor.this.mSystemName);
            }
            TimeoutRfidSensor.this.cleanUpTimeout();
        }
    }
}

