/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.generic.standalone;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidReply;
import jmri.jmrix.rfid.RfidSensorManager;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.TimeoutRfidSensor;
import jmri.jmrix.rfid.generic.standalone.StandaloneMessage;
import jmri.jmrix.rfid.generic.standalone.StandaloneReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneSensorManager
extends RfidSensorManager {
    private final RfidTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(StandaloneSensorManager.class);

    public StandaloneSensorManager(RfidSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.attach();
    }

    private void attach() {
        this.tc.addRfidListener(this);
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("Create new Sensor");
        TimeoutRfidSensor s = new TimeoutRfidSensor(systemName, userName);
        s.addPropertyChangeListener(this);
        return s;
    }

    @Override
    public void message(RfidMessage m) {
        if (m.toString().equals(new StandaloneMessage(this.tc.getAdapterMemo().getProtocol().initString(), 0).toString())) {
            log.info("Sent init string: {}", (Object)m);
        } else {
            super.message(m);
        }
    }

    @Override
    public synchronized void reply(RfidReply r) {
        if (r instanceof StandaloneReply) {
            this.processReply((StandaloneReply)r);
        }
    }

    private void processReply(StandaloneReply r) {
        if (!this.tc.getAdapterMemo().getProtocol().isValid(r)) {
            log.warn("Invalid message - skipping {}", (Object)r);
            return;
        }
        IdTag idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(this.tc.getAdapterMemo().getProtocol().getTag(r));
        TimeoutRfidSensor sensor = (TimeoutRfidSensor)this.provideSensor(this.getSystemNamePrefix() + "1");
        sensor.notify(idTag);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateTrimmedMin1NumberSystemNameFormat(name, locale);
    }
}

