/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.merg.concentrator;

import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.implementation.decorators.TimeoutReporter;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidReply;
import jmri.jmrix.rfid.RfidReporter;
import jmri.jmrix.rfid.RfidReporterManager;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorMessage;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcentratorReporterManager
extends RfidReporterManager {
    private final RfidTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(ConcentratorReporterManager.class);

    public ConcentratorReporterManager(RfidSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.attach();
    }

    private void attach() {
        this.tc.addRfidListener(this);
    }

    @Override
    @Nonnull
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("Create new Reporter: {}", (Object)systemName);
        if (!systemName.matches(this.getSystemNamePrefix() + "[" + this.tc.getRange() + "]")) {
            log.warn("Invalid Reporter name: {}} - out of supported range {}", (Object)systemName, (Object)this.tc.getRange());
            throw new IllegalArgumentException("Invalid Reporter name: " + systemName + " - out of supported range " + this.tc.getRange());
        }
        TimeoutReporter r = new TimeoutReporter(new RfidReporter(systemName, userName));
        r.addPropertyChangeListener(this);
        return r;
    }

    @Override
    public void message(RfidMessage m) {
        if (m.toString().equals(new ConcentratorMessage(this.tc.getAdapterMemo().getProtocol().initString(), 0).toString())) {
            log.info("Sent init string: {}", (Object)m);
        } else {
            super.message(m);
        }
    }

    @Override
    public synchronized void reply(RfidReply r) {
        if (r instanceof ConcentratorReply) {
            this.processReply((ConcentratorReply)r);
        }
    }

    private void processReply(ConcentratorReply r) {
        if (!this.tc.getAdapterMemo().getProtocol().isValid(r)) {
            log.warn("Invalid message - skipping {}", (Object)r);
            return;
        }
        if (!r.isInRange()) {
            log.warn("Invalid concentrator reader range - skipping {}", (Object)r);
            return;
        }
        IdTag idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(this.tc.getAdapterMemo().getProtocol().getTag(r));
        TimeoutReporter report = (TimeoutReporter)this.provideReporter(this.getSystemNamePrefix() + r.getReaderPort());
        report.notify(idTag);
    }
}

