/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.merg.concentrator;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorMessage;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcentratorTrafficController
extends RfidTrafficController {
    private final String range;
    boolean sendInterlock = false;
    private static final Logger log = LoggerFactory.getLogger(ConcentratorTrafficController.class);

    public ConcentratorTrafficController(RfidSystemConnectionMemo memo, String range) {
        this.adapterMemo = memo;
        this.range = range;
        this.logDebug = log.isDebugEnabled();
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    @Override
    public void sendInitString() {
        String init = this.adapterMemo.getProtocol().initString();
        if (init.length() > 0) {
            this.sendRfidMessage(new ConcentratorMessage(init, 0), null);
        }
    }

    @Override
    public RfidMessage getRfidMessage(int length) {
        return new ConcentratorMessage(length);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        this.sendInterlock = ((RfidMessage)m).getInterlocked();
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        ConcentratorReply reply = new ConcentratorReply(this.adapterMemo.getTrafficController());
        return reply;
    }

    @Override
    public String getRange() {
        return this.range;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return this.adapterMemo.getProtocol().endOfMessage(msg);
    }
}

