/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.protocol.parallax;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallaxRfidProtocol
extends RfidProtocol {
    public static final int SPECIFICMAXSIZE = 12;
    private static final Logger log = LoggerFactory.getLogger(ParallaxRfidProtocol.class);

    public static final int getMaxSize() {
        return 12;
    }

    @Override
    public String initString() {
        return "";
    }

    @Override
    public String getTag(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(10);
        for (int i = 1; i < 11; ++i) {
            sb.append((char)msg.getElement(i));
        }
        return sb.toString();
    }

    @Override
    public String getCheckSum(AbstractMRReply msg) {
        return "";
    }

    @Override
    public boolean isValid(AbstractMRReply msg) {
        return msg.getElement(0) == 10 && msg.getElement(11) == 13;
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() == 12) {
            if (msg.getElement(0) == 10 && msg.getElement(11) == 13) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a correctly formed message");
            }
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString(AbstractMRReply msg) {
        if (this.isValid(msg)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Reply from Parallax reader.");
            sb.append(" Tag read ");
            sb.append(this.getTag(msg));
            return sb.toString();
        }
        return super.toMonitorString(msg);
    }
}

