/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.protocol.seeedstudio;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeeedStudioRfidProtocol
extends RfidProtocol {
    private static final int SPECIFICMAXSIZE = 14;
    private static final Logger log = LoggerFactory.getLogger(SeeedStudioRfidProtocol.class);

    public SeeedStudioRfidProtocol() {
    }

    public SeeedStudioRfidProtocol(char concentratorFirst, char concentratorLast, int portPosition) {
        super(concentratorFirst, concentratorLast, portPosition);
    }

    public static final int getMaxSize() {
        return 14;
    }

    @Override
    public String initString() {
        return "";
    }

    @Override
    public String getTag(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(10);
        for (int i = 1; i < 11; ++i) {
            sb.append((char)msg.getElement(i));
        }
        return sb.toString();
    }

    @Override
    public boolean providesChecksum() {
        return true;
    }

    @Override
    public String getCheckSum(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(2);
        for (int i = 11; i < 13; ++i) {
            sb.append((char)msg.getElement(i));
        }
        return sb.toString();
    }

    @Override
    public boolean isValid(AbstractMRReply msg) {
        return (!this.isConcentrator && msg.getElement(0) == 2 && (msg.getElement(13) & 0xFF) == 3 || this.isConcentrator && msg.getElement(this.portPosition) >= this.concentratorFirst && msg.getElement(this.portPosition) <= this.concentratorLast && (msg.getElement(13) & 0xFF) == 62) && this.isCheckSumValid(msg);
    }

    public boolean isCheckSumValid(AbstractMRReply msg) {
        byte[] tag = SeeedStudioRfidProtocol.convertHexString(this.getTag(msg));
        int checksum = 0;
        for (int i = 0; i < 5; ++i) {
            checksum ^= tag[i];
            log.debug("read {}", (Object)tag[i]);
        }
        log.debug("Checksum: {} converted: {}", (Object)this.getCheckSum(msg), (Object)SeeedStudioRfidProtocol.convertHexString(this.getCheckSum(msg))[0]);
        return checksum == SeeedStudioRfidProtocol.convertHexString(this.getCheckSum(msg))[0];
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() == 14) {
            if (((msg.getElement(13) & 0xFF) == 3 || (msg.getElement(13) & 0xFF) == 62) && (msg.getElement(12) & 0xFF) == 10 && (msg.getElement(11) & 0xFF) == 13) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a correctly formed message");
            }
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString(AbstractMRReply msg) {
        if (this.isValid(msg)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Reply from SeeedStudio reader.");
            if (this.isConcentrator) {
                sb.append(" Reply from port ");
                sb.append(this.getReaderPort(msg));
            }
            sb.append(" Tag read ");
            sb.append(this.getTag(msg));
            sb.append(" checksum ");
            sb.append(this.getCheckSum(msg));
            sb.append(" valid? ");
            sb.append(this.isCheckSumValid(msg) ? "yes" : "no");
            return sb.toString();
        }
        return super.toMonitorString(msg);
    }
}

