/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.swing.tagcarwin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrix.rfid.swing.tagcarwin.Bundle;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociateTag
extends JmriPanel
implements ActionListener,
ListSelectionListener {
    private static final Logger log = LoggerFactory.getLogger(AssociateTag.class);
    String tag;
    private final JButton okayButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final DefaultListModel<String> roadListModel = new DefaultListModel();
    private final DefaultListModel<String> numberListModel = new DefaultListModel();
    private final JList<String> roadCombo = new JList();
    private final JList<String> numberCombo = new JList();
    private final JCheckBox includeCars = new JCheckBox();
    private final JLabel message = new JLabel("");
    private final String includeCarsString = this.getClass().getName() + "IncludeAllCars";
    private final ArrayList<String> roadList = new ArrayList();
    private final ArrayList<String> roadsWith = new ArrayList();
    private final Hashtable<String, List<String>> numbersWith = new Hashtable();
    private final Hashtable<String, List<String>> roadNumbers = new Hashtable();
    protected CarManager carManager = InstanceManager.getDefault(CarManager.class);
    protected IdTagManager tagManager = InstanceManager.getDefault(IdTagManager.class);
    JmriJFrame parentFrame;

    public void setParentFrame(JmriJFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public AssociateTag(String thisTag) {
        this.tag = thisTag;
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("AssociateTitle") + this.tag;
    }

    @Override
    public void dispose() {
        UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
        pm.setSimplePreferenceState(this.includeCarsString, this.includeCars.isSelected());
    }

    @Override
    public void initComponents() {
        log.debug("setting up the AssociateTag panel");
        this.initRoads();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 500));
        this.setMinimumSize(new Dimension(500, 450));
        UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
        this.includeCars.setSelected(pm.getSimplePreferenceState(this.includeCarsString));
        JScrollPane roadScroll = new JScrollPane();
        roadScroll.setMinimumSize(new Dimension(150, 250));
        roadScroll.setViewportView(this.roadCombo);
        this.roadCombo.setVisibleRowCount(10);
        this.roadCombo.setSelectionMode(0);
        this.roadCombo.setLayoutOrientation(0);
        this.roadCombo.addListSelectionListener(this);
        this.roadCombo.setMinimumSize(new Dimension(150, 250));
        this.roadCombo.setModel(this.roadListModel);
        this.add((Component)roadScroll, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 21, 1, new Insets(10, 10, 10, 10), 10, 10));
        JScrollPane numberScroll = new JScrollPane();
        numberScroll.setViewportView(this.numberCombo);
        numberScroll.setMinimumSize(new Dimension(150, 250));
        this.numberCombo.setSelectionMode(0);
        this.numberCombo.setVisibleRowCount(10);
        this.numberCombo.setLayoutOrientation(0);
        this.numberCombo.setMinimumSize(new Dimension(75, 75));
        this.numberCombo.setEnabled(false);
        this.numberCombo.setModel(this.numberListModel);
        this.add((Component)numberScroll, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 22, 1, new Insets(10, 10, 10, 10), 10, 10));
        JLabel tagLabel = new JLabel();
        tagLabel.setText(Bundle.getMessage("AssociateTag"));
        this.add((Component)tagLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 22, 2, new Insets(5, 5, 5, 5), 5, 5));
        JLabel thisTag = new JLabel(this.tag);
        this.add((Component)thisTag, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 5, 5));
        this.includeCars.setText(Bundle.getMessage("AssociateIncludeAll"));
        this.includeCars.setToolTipText(Bundle.getMessage("AssociateAllToolTip"));
        this.includeCars.addActionListener(this);
        this.add((Component)this.includeCars, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.message.setMinimumSize(new Dimension(400, 10));
        this.add((Component)this.message, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 10, 10), 5, 5));
        this.message.setText("  ");
        this.okayButton.setText(Bundle.getMessage("AssociateOkay"));
        this.okayButton.addActionListener(this);
        this.okayButton.setEnabled(false);
        this.add((Component)this.okayButton, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(20, 20, 20, 20), 10, 10));
        this.cancelButton.setText(Bundle.getMessage("AssociateCancel"));
        this.cancelButton.addActionListener(this);
        this.add((Component)this.cancelButton, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 22, 0, new Insets(20, 20, 20, 20), 10, 10));
        this.setRoads();
        if (this.includeCars.isSelected() && this.roadsWith.size() < 1) {
            this.message.setText(Bundle.getMessage("AssociateNoCars"));
        }
        if (this.roadList.size() < 1) {
            this.message.setText(Bundle.getMessage("AssociateNoRoads"));
        }
    }

    private void initRoads() {
        log.debug("building a list of road number with their cars");
        this.roadList.clear();
        this.roadNumbers.clear();
        this.roadsWith.clear();
        this.numbersWith.clear();
        List carList = this.carManager.getList();
        for (Car thisCar : carList) {
            ArrayList<String> tempArray;
            if (this.numbersWith.containsKey(thisCar.getRoadName())) {
                this.numbersWith.get(thisCar.getRoadName()).add(thisCar.getNumber());
            } else {
                this.roadsWith.add(thisCar.getRoadName());
                tempArray = new ArrayList<String>();
                tempArray.add(thisCar.getNumber());
                this.numbersWith.put(thisCar.getRoadName(), tempArray);
            }
            if (!"".equals(thisCar.getRfid())) continue;
            if (this.roadNumbers.containsKey(thisCar.getRoadName())) {
                this.roadNumbers.get(thisCar.getRoadName()).add(thisCar.getNumber());
                continue;
            }
            this.roadList.add(thisCar.getRoadName());
            tempArray = new ArrayList();
            tempArray.add(thisCar.getNumber());
            this.roadNumbers.put(thisCar.getRoadName(), tempArray);
        }
        Collections.sort(this.roadsWith);
        Collections.sort(this.roadList);
        for (String road : this.roadList) {
            Collections.sort(this.roadNumbers.get(road), new AlphanumComparator());
        }
        for (String road : this.roadsWith) {
            Collections.sort(this.numbersWith.get(road), new AlphanumComparator());
        }
    }

    private void setOneRoad() {
        this.message.setText(Bundle.getMessage("AssociateReady"));
        this.numberCombo.setEnabled(true);
        this.roadCombo.setSelectedIndex(0);
    }

    private void setRoads() {
        this.roadCombo.removeListSelectionListener(this);
        this.numberCombo.removeListSelectionListener(this);
        this.message.setText(" ");
        this.numberListModel.clear();
        this.okayButton.setEnabled(false);
        this.roadListModel.clear();
        ArrayList<String> theList = this.includeCars.isSelected() ? this.roadsWith : this.roadList;
        for (String road : theList) {
            this.roadListModel.addElement(road);
        }
        this.roadCombo.addListSelectionListener(this);
        if (theList.size() == 1) {
            this.setOneRoad();
        }
    }

    private void closePage() {
        this.dispose();
        this.parentFrame.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okayButton)) {
            String thisRoad = this.roadCombo.getSelectedValue();
            String thisNumber = this.numberCombo.getSelectedValue();
            if (thisRoad == null || thisNumber == null) {
                this.message.setText(Bundle.getMessage("AssociateNeedSelected"));
                return;
            }
            Car thisCar = (Car)this.carManager.getByRoadAndNumber(thisRoad, thisNumber);
            if (thisCar == null) {
                log.error("Car was pulled from combo but was not found {} {}", (Object)thisRoad, (Object)thisNumber);
                return;
            }
            if (e.getSource().equals(this.okayButton)) {
                log.debug("setting this tag ({}) to car {} with number {}", new Object[]{this.tag, thisRoad, thisNumber});
                this.tagManager.provideIdTag(this.tag);
                thisCar.setRfid(this.tag);
                this.closePage();
            }
        } else if (e.getSource().equals(this.cancelButton)) {
            log.debug("closing the Associate panel");
            this.closePage();
        } else if (e.getSource().equals(this.includeCars)) {
            log.debug("the includeCars checkbox is changing - rebuilding lists");
            this.setRoads();
        } else {
            log.error("action performed for an unrecognized source");
            return;
        }
    }

    private void doNumbers(String road) {
        this.numberCombo.removeListSelectionListener(this);
        this.numberListModel.clear();
        List<String> numberList = this.includeCars.isSelected() ? this.numbersWith.get(road) : this.roadNumbers.get(road);
        if (numberList == null) {
            log.error("didn't find the road in the list");
            return;
        }
        for (String thisNumber : numberList) {
            this.numberListModel.addElement(thisNumber);
        }
        this.numberCombo.addListSelectionListener(this);
        this.numberCombo.setEnabled(true);
        if (numberList.size() == 1) {
            this.numberCombo.setSelectedIndex(0);
            this.message.setText(Bundle.getMessage("AssociateOkayReady"));
        } else {
            this.message.setText("  ");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        log.debug("got a list selection event");
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.roadCombo)) {
            this.numberCombo.setEnabled(false);
            this.numberCombo.removeListSelectionListener(this);
            this.okayButton.setEnabled(false);
            if (this.roadCombo.getSelectedIndex() == -1) {
                log.debug("no selection - turning off numbers combo");
                this.message.setText(" ");
                this.okayButton.setEnabled(false);
                this.numberCombo.setEnabled(false);
                this.numberListModel.clear();
            } else {
                this.doNumbers(this.roadCombo.getSelectedValue());
                this.message.setText(Bundle.getMessage("AssociateReady"));
                this.numberCombo.addListSelectionListener(this);
                this.numberCombo.setEnabled(true);
            }
        } else if (e.getSource().equals(this.numberCombo)) {
            if (this.numberCombo.getSelectedIndex() == -1) {
                log.debug("road number was deselected - turning off okay button");
                this.message.setText(Bundle.getMessage("AssociateReady"));
                this.okayButton.setEnabled(false);
            }
            this.okayButton.setEnabled(true);
            this.message.setText(Bundle.getMessage("AssociateOkayReady"));
        } else {
            log.error("don't recognize the source of the event");
        }
    }
}

