/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.swing.tagcarwin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.gui.CarEditFrame;
import jmri.jmrix.rfid.swing.tagcarwin.AssociateFrame;
import jmri.jmrix.rfid.swing.tagcarwin.AssociateTag;
import jmri.jmrix.rfid.swing.tagcarwin.Bundle;
import jmri.jmrix.rfid.swing.tagcarwin.TagCarItem;
import jmri.jmrix.rfid.swing.tagcarwin.TagMonitorPane;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataModel
extends AbstractTableModel
implements PropertyChangeListener,
ItemListener,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(TableDataModel.class);
    protected JTable tableParent = null;
    protected static final int TIME_COLUMN = 0;
    protected static final int ROAD_COLUMN = 1;
    protected static final int CAR_NUMBER_COLUMN = 2;
    protected static final int TAG_COLUMN = 3;
    protected static final int LOCATION_COLUMN = 4;
    protected static final int TRACK_COLUMN = 5;
    protected static final int TRAIN_COLUMN = 6;
    protected static final int TRAIN_POSITION_COLUMN = 7;
    protected static final int DESTINATION_COLUMN = 8;
    protected static final int ACTION1_COLUMN = 9;
    protected static final int ACTION2_COLUMN = 10;
    protected static final int COLUMN_COUNT = 11;
    private final int[] tableColumn_widths = new int[]{60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60};
    List<TagCarItem> tagList = new Vector<TagCarItem>();
    protected List<String> locations;
    protected Hashtable<String, List<String>> trackLists;
    TagMonitorPane parentPane = null;
    CarEditFrame cef;
    AssociateFrame associateFrame;
    boolean forceSetLocation = false;
    private boolean addingRow = false;
    protected boolean showTimestamps = false;
    private int rowMax = 20;

    public void setForceSetLocation(boolean forceSetLocation) {
        this.forceSetLocation = forceSetLocation;
    }

    public TableDataModel(TagMonitorPane parentPane) {
        this.parentPane = parentPane;
    }

    public TableDataModel() {
    }

    public void showTimestamps(boolean showTimestamps) {
        this.showTimestamps = showTimestamps;
        XTableColumnModel tcm = (XTableColumnModel)this.tableParent.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(0), showTimestamps);
        this.fireTableDataChanged();
    }

    public void setRowMax(int rowMax) {
        this.cleanTable(rowMax, true);
        this.rowMax = rowMax;
    }

    private void setCombos(JComboBox<String> locationBox, JComboBox<String> trackBox, RollingStock car) {
        locationBox.removeItemListener(this);
        trackBox.removeItemListener(this);
        locationBox.addItem("");
        for (String loc : this.locations) {
            locationBox.addItem(loc);
        }
        if (car.getLocation() == null) {
            locationBox.setSelectedIndex(0);
            trackBox.addItem("");
            trackBox.setEnabled(false);
        } else {
            locationBox.addItemListener(this);
            trackBox.addItemListener(this);
            String locName = car.getLocationName();
            locationBox.setSelectedItem(locName);
            List<String> tracksHere = this.trackLists.get(locName);
            for (String thisTrack : tracksHere) {
                trackBox.addItem(thisTrack);
            }
            if (car.getTrack() != null) {
                trackBox.setSelectedItem(car.getTrack().getName());
            }
            if (tracksHere.size() == 2) {
                trackBox.setSelectedIndex(1);
            }
            trackBox.addItemListener(this);
        }
        locationBox.addItemListener(this);
    }

    public void clearTable() {
        log.debug("clearing the RFID tag car window");
        this.cleanTable(0, true);
    }

    private void cleanTable(int newRowMax, boolean fireChange) {
        boolean rowsRemoved = false;
        if (this.tagList.size() <= newRowMax) {
            return;
        }
        if (this.tableParent.isEditing()) {
            this.tableParent.getCellEditor().stopCellEditing();
        }
        while (this.tagList.size() > newRowMax) {
            this.tagList.remove(0);
            rowsRemoved = true;
        }
        if (rowsRemoved && fireChange) {
            this.fireTableDataChanged();
        }
    }

    public void add(TagCarItem newItem) {
        this.addingRow = true;
        this.cleanTable(this.rowMax - 1, false);
        RollingStock newCar = newItem.getCurrentCar();
        newItem.getAction1().addActionListener(this);
        if (newCar != null) {
            JComboBox<String> carLocation = new JComboBox<String>();
            JComboBox<String> carTrack = new JComboBox<String>();
            this.setCombos(carLocation, carTrack, newCar);
            newItem.setLocation(carLocation);
            newItem.setTrack(carTrack);
            newItem.getAction2().addActionListener(this);
        }
        this.tagList.add(newItem);
        this.parentPane.setMessageNormal("");
        this.fireTableDataChanged();
        this.addingRow = false;
    }

    public void setLast(LocalTime newLast) {
        if (this.tagList.size() > 0) {
            this.tagList.get(this.tagList.size() - 1).setLastSeen(newLast);
            this.fireTableCellUpdated(this.tagList.size() - 1, 0);
        }
    }

    public void setParent(JTable parent) {
        this.tableParent = parent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public int getRowCount() {
        return this.tagList.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.tagList.size()) {
            return "";
        }
        TagCarItem current = this.tagList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return current.getLastSeen().toString();
            }
            case 1: {
                return current.getRoad();
            }
            case 2: {
                return current.getCarNumber();
            }
            case 3: {
                return current.getTag();
            }
            case 4: {
                if (current.getCurrentCar() == null) {
                    return "";
                }
                if (current.getLocationCombo().getSelectedIndex() == -1) {
                    return "";
                }
                return current.getLocationCombo().getSelectedItem();
            }
            case 5: {
                if (current.getCurrentCar() == null) {
                    return "";
                }
                if (current.getLocationCombo().getSelectedIndex() == -1) {
                    return "";
                }
                return current.getTrackCombo().getSelectedItem();
            }
            case 6: {
                if (current.getTrain() == null) {
                    return "";
                }
                return current.getTrain();
            }
            case 8: {
                if (current.getDestination() == null) {
                    return "";
                }
                return current.getDestination();
            }
            case 7: {
                if (current.getTrainPosition() == null) {
                    return "";
                }
                return current.getTrainPosition();
            }
            case 9: {
                return current.getAction1().getText();
            }
            case 10: {
                if (current.getAction2() == null) {
                    return "";
                }
                return current.getAction2().getText();
            }
        }
        return "unknown";
    }

    private void setCarLocation(RollingStock car, TagCarItem thisRow) {
        String retValue;
        if (car == null) {
            log.error("attempting to set the location of a null car");
            return;
        }
        log.debug("Setting location of car {} - {}", (Object)car.getRoadName(), (Object)car.getNumber());
        if (!thisRow.isLocationReady()) {
            log.error("should not be here - this row is not yet ready");
            return;
        }
        if (thisRow.getTempLocation().equals("")) {
            retValue = car.setLocation(null, null);
        } else {
            Location thisLocation = this.parentPane.locationManager.getLocationByName(thisRow.getTempLocation());
            if (thisLocation == null) {
                log.error("Did not find location identified in ComboBox - {}", (Object)thisRow.getTempLocation());
                return;
            }
            Track thisTrack = null;
            for (Track track : thisLocation.getTracksList()) {
                if (!track.getName().equals(thisRow.getTempTrack())) continue;
                thisTrack = track;
                break;
            }
            if (thisTrack == null) {
                log.error("Did not find expected track at this location L - T -- {} - {}", (Object)thisRow.getTempLocation(), (Object)thisRow.getTempTrack());
                return;
            }
            retValue = car.setLocation(thisLocation, thisTrack, this.forceSetLocation);
        }
        if (retValue.equals("okay")) {
            this.parentPane.setMessageNormal(Bundle.getMessage("MonitorLocationSet"));
            thisRow.resetTempValues();
        } else {
            this.parentPane.setMessageError("MonitorLocationFailed");
        }
    }

    private void doEditCar(RollingStock thisCar) {
        if (this.cef != null) {
            this.cef.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            this.cef = new CarEditFrame();
            this.cef.initComponents();
            this.cef.load((Car)thisCar);
        });
    }

    private void doSetTag(String thisTag, TagCarItem thisRow) {
        if (this.associateFrame != null) {
            this.associateFrame.dispose();
        }
        SwingUtilities.invokeLater(() -> new AssociateFrame(new AssociateTag(thisTag), Bundle.getMessage("AssociateTitle") + " " + thisTag).initComponents());
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TagCarItem thisRowValue = this.tagList.get(row);
        switch (col) {
            case 4: {
                if (!(value instanceof String)) break;
                log.debug("new value for Location column - {}", value);
                this.locationItemUpdated(thisRowValue, (String)value);
                break;
            }
            case 5: {
                if (!(value instanceof String)) break;
                this.trackItemUpdate(thisRowValue, (String)value);
                break;
            }
            case 9: {
                log.debug("setValueAt for Action1 column");
                return;
            }
            case 10: {
                log.debug("setValueAt for Action2 column");
                break;
            }
            default: {
                log.error("should not be setting value for column {}", (Object)col);
            }
        }
    }

    Component getLocationRowEditor(JTable table, Object value, boolean isSelected, int row, int column) {
        int tempCol = column;
        if (!this.parentPane.getShowTimestamps()) {
            tempCol = column + 1;
        }
        if (tempCol != 4) {
            log.error("getLocationRowEditor called for other than Location column {}", (Object)column);
            return null;
        }
        if (this.tagList.get(row).getCurrentCar() == null) {
            log.debug("this row does not have a car associated -- cannot edit");
            JComboBox<String> newBox = new JComboBox<String>();
            newBox.addItem("");
            return newBox;
        }
        return this.tagList.get(row).getLocationCombo();
    }

    Component getTrackRowEditor(JTable table, Object value, boolean isSelected, int row, int column) {
        int tempCol = column;
        if (!this.parentPane.getShowTimestamps()) {
            tempCol = column + 1;
        }
        if (tempCol != 5) {
            log.error("Track row column called for incorrect column: {}", (Object)column);
            return null;
        }
        return this.tagList.get(row).getTrackCombo();
    }

    private void buildLocationValues() {
        this.locations = new ArrayList<String>();
        this.trackLists = new Hashtable();
        for (Location loc : this.parentPane.locationManager.getList()) {
            this.locations.add(loc.getName());
            List<Track> listOfTracks = loc.getTracksByNameList(null);
            ArrayList<String> tempTrack = new ArrayList<String>();
            tempTrack.add("");
            for (Track thisTrack : listOfTracks) {
                tempTrack.add(thisTrack.getName());
            }
            Collections.sort(tempTrack);
            this.trackLists.put(loc.getName(), tempTrack);
        }
        Collections.sort(this.locations);
    }

    void initTable() {
        this.buildLocationValues();
        XTableColumnModel tcm = new XTableColumnModel();
        this.tableParent.setColumnModel(tcm);
        this.tableParent.createDefaultColumnsFromModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setPreferredWidth(this.tableColumn_widths[i]);
        }
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(9).setCellRenderer(buttonRenderer);
        tcm.getColumn(10).setCellRenderer(buttonRenderer);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(0), this.showTimestamps);
        EditTrackCellEditor locationCellEditor = new EditTrackCellEditor(this);
        EditTrackCellEditor trackCellEditor = new EditTrackCellEditor(this);
        tcm.getColumnByModelIndex(4).setCellEditor(locationCellEditor);
        tcm.getColumnByModelIndex(5).setCellEditor(trackCellEditor);
        tcm.getColumnByModelIndex(9).setCellEditor(new EditTrackCellEditor(this));
        tcm.getColumnByModelIndex(10).setCellEditor(new EditTrackCellEditor(this));
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("MonitorTimeStampCol");
            }
            case 1: {
                return Bundle.getMessage("MonitorRoadCol");
            }
            case 2: {
                return Bundle.getMessage("MonitorCarNumCol");
            }
            case 3: {
                return Bundle.getMessage("MonitorTagCol");
            }
            case 4: {
                return Bundle.getMessage("MonitorLocation");
            }
            case 5: {
                return Bundle.getMessage("MonitorTrack");
            }
            case 6: {
                return Bundle.getMessage("MonitorTrain");
            }
            case 7: {
                return Bundle.getMessage("MonitorTrainPosition");
            }
            case 8: {
                return Bundle.getMessage("MonitorDestination");
            }
            case 9: {
                return Bundle.getMessage("MonitorAction1");
            }
            case 10: {
                return Bundle.getMessage("MonitorAction2");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 7: {
                return Integer.class;
            }
            case 4: 
            case 5: {
                return JComboBox.class;
            }
            case 9: 
            case 10: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private void locationItemUpdated(TagCarItem thisRow, String newvalue) {
        if (newvalue.equals("")) {
            if (thisRow.getLocationValue() == null) {
                return;
            }
            thisRow.setUpdatedLocation("", "");
            thisRow.getTrackCombo().setEnabled(false);
        } else {
            thisRow.getTrackCombo().removeItemListener(this);
            List<String> tracksHere = this.trackLists.get(newvalue);
            thisRow.getTrackCombo().removeAllItems();
            thisRow.getTrackCombo().setEnabled(true);
            for (String thisTrack : tracksHere) {
                thisRow.getTrackCombo().addItem(thisTrack);
            }
            if (tracksHere.size() == 2) {
                thisRow.getTrackCombo().setSelectedIndex(1);
                thisRow.setUpdatedLocation(newvalue, tracksHere.get(1));
                if (thisRow.isLocationReady()) {
                    this.parentPane.setMessageNormal(Bundle.getMessage("MonitorReadyToSet"));
                    thisRow.getAction1().setEnabled(true);
                } else {
                    this.parentPane.setMessageNormal("MonitorSetTrackMsg");
                    thisRow.getAction1().setEnabled(false);
                }
            } else {
                thisRow.setUpdatedLocation(newvalue, "");
                this.parentPane.setMessageNormal(Bundle.getMessage("MonitorSetTrackMsg"));
                thisRow.getAction1().setEnabled(false);
            }
            thisRow.getTrackCombo().addItemListener(this);
        }
    }

    private void trackItemUpdate(TagCarItem thisRow, String newValue) {
        thisRow.setUpdatedTrack(newValue);
        if (thisRow.isLocationReady()) {
            this.parentPane.setMessageNormal(Bundle.getMessage("MonitorReadyToSet"));
            thisRow.getAction1().setEnabled(true);
        } else {
            thisRow.getAction1().setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        log.debug("item event fired for {} ", e.getItem());
        if (this.addingRow || e.getStateChange() != 1) {
            return;
        }
        for (TagCarItem thisRow : this.tagList) {
            if (e.getSource().equals(thisRow.getLocationCombo())) {
                this.locationItemUpdated(thisRow, (String)e.getItem());
                continue;
            }
            if (e.getSource().equals(thisRow.getTrackCombo())) {
                this.trackItemUpdate(thisRow, (String)e.getItem());
                continue;
            }
            log.error("got an ItemEvent for an unknown source");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Got an action performed for a button");
        for (TagCarItem thisRow : this.tagList) {
            if (e.getSource().equals(thisRow.getAction1())) {
                if (thisRow.getCurrentCar() == null) {
                    this.doSetTag(thisRow.getTag(), thisRow);
                } else {
                    this.setCarLocation(thisRow.getCurrentCar(), thisRow);
                }
                return;
            }
            if (!e.getSource().equals(thisRow.getAction2())) continue;
            this.doEditCar(thisRow.getCurrentCar());
            return;
        }
        log.error("Got an actionPerformed but dont recognize source");
    }

    static class EditTrackCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TableDataModel model;
        private Component value;

        public EditTrackCellEditor(TableDataModel model) {
            this.model = model;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.model == null) {
                log.error("was not called through the correct constructor - model is null");
                return null;
            }
            int tempCol = column;
            if (this.model.parentPane == null) {
                log.error("parent pane pointer is missing");
                return null;
            }
            if (!this.model.parentPane.getShowTimestamps()) {
                tempCol = column + 1;
            }
            if (tempCol == 5) {
                this.value = this.model.tagList.get(row).getTrackCombo();
                return this.model.getTrackRowEditor(table, value, isSelected, row, column);
            }
            if (tempCol == 4) {
                this.value = this.model.tagList.get(row).getLocationCombo();
                return this.model.getLocationRowEditor(table, value, isSelected, row, column);
            }
            if (tempCol == 9) {
                this.value = this.model.tagList.get(row).getAction1();
                return this.model.tagList.get(row).getAction1();
            }
            if (tempCol == 10) {
                this.value = this.model.tagList.get(row).getAction2();
                return this.model.tagList.get(row).getAction2();
            }
            log.error("unable to determine column (value {} - returning null for table editor", (Object)column);
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }
}

