/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.swing.tagcarwin;

import java.time.LocalTime;
import javax.swing.JButton;
import javax.swing.JComboBox;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.rollingstock.RollingStock;

public class TagCarItem {
    private String tag;
    private String road;
    private String carNumber;
    private String locationName;
    private Location locationValue;
    private String trackName;
    private String train;
    private Integer trainPosition;
    protected JComboBox<String> locationCombo;
    protected JComboBox<String> track;
    private RollingStock currentCar;
    private String destination;
    private LocalTime lastSeen;
    private JButton action1 = null;
    private JButton action2 = null;
    private LocalTime tagTime;
    private int repeatCount = 0;
    private boolean locationUpdated = false;
    private boolean trackUpdated = false;
    private boolean readyToSetLocation = false;
    private String tempLocation = null;
    private String tempTrack = null;

    public void setUpdatedLocation(String location, String track) {
        this.tempLocation = location;
        this.locationUpdated = true;
        if (track != null) {
            this.tempTrack = track;
            this.trackUpdated = true;
            this.readyToSetLocation = true;
        } else {
            this.readyToSetLocation = this.trackUpdated;
        }
    }

    public void setUpdatedTrack(String thisTrack) {
        this.tempTrack = thisTrack;
        this.trackUpdated = true;
        this.readyToSetLocation = this.locationUpdated;
    }

    public String getUpdatedLocation() {
        return this.tempLocation;
    }

    public String getUpdatedTrack() {
        return this.tempTrack;
    }

    public boolean isLocationReady() {
        return this.readyToSetLocation;
    }

    public void resetTempValues() {
        this.locationUpdated = false;
        this.trackUpdated = false;
        this.tempLocation = null;
        this.tempTrack = null;
    }

    public JComboBox<String> getLocationCombo() {
        return this.locationCombo;
    }

    public void setLocation(JComboBox<String> location) {
        this.locationCombo = location;
    }

    public void setTrack(JComboBox<String> track) {
        this.track = track;
    }

    public JComboBox<String> getTrackCombo() {
        return this.track;
    }

    public TagCarItem() {
        this.tagTime = LocalTime.now();
    }

    public RollingStock getCurrentCar() {
        return this.currentCar;
    }

    public void setCurrentCar(RollingStock currentCar) {
        this.currentCar = currentCar;
    }

    public TagCarItem(String newTag) {
        this.tag = newTag;
        this.lastSeen = this.tagTime = LocalTime.now();
    }

    public TagCarItem(String newTag, LocalTime tagTime) {
        this.tag = newTag;
        this.tagTime = tagTime;
        this.lastSeen = tagTime;
    }

    public Integer getTrainPosition() {
        return this.trainPosition;
    }

    public void setTrainPosition(Integer trainPosition) {
        this.trainPosition = trainPosition;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public JButton getAction1() {
        return this.action1;
    }

    public void setAction1(JButton action1) {
        this.action1 = action1;
    }

    public JButton getAction2() {
        return this.action2;
    }

    public void setAction2(JButton action2) {
        this.action2 = action2;
    }

    public void setLastSeen(LocalTime lastSeen) {
        this.lastSeen = lastSeen;
        ++this.repeatCount;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public LocalTime getLastSeen() {
        return this.lastSeen;
    }

    public LocalTime getTagTime() {
        return this.tagTime;
    }

    public void setTagTime(LocalTime tagTime) {
        this.tagTime = tagTime;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getRoad() {
        return this.road;
    }

    public void setRoad(String road) {
        this.road = road;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }

    public Location getLocationValue() {
        return this.locationValue;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocation(Location location) {
        this.locationValue = location;
    }

    public void setLocation(String location) {
        this.locationName = location;
    }

    public String getTrack() {
        return this.trackName;
    }

    public void setTrack(String track) {
        this.trackName = track;
    }

    public String getTrain() {
        return this.train;
    }

    public void setTrain(String train) {
        this.train = train;
    }

    public String getTempLocation() {
        return this.tempLocation;
    }

    public String getTempTrack() {
        return this.tempTrack;
    }
}

