/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.swing.tagcarwin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.time.LocalTime;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrix.rfid.RfidListener;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidReply;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.swing.RfidPanelInterface;
import jmri.jmrix.rfid.swing.tagcarwin.Bundle;
import jmri.jmrix.rfid.swing.tagcarwin.TableDataModel;
import jmri.jmrix.rfid.swing.tagcarwin.TagCarItem;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagMonitorPane
extends JmriPanel
implements RfidListener,
RfidPanelInterface,
TableModelListener {
    private static final Logger log = LoggerFactory.getLogger(TagMonitorPane.class);
    TableDataModel dataModel = null;
    protected Integer currentRowCount = 15;
    private String lastTagSeen = "";
    private final ArrayList<RollingStock> lastTrainCars = new ArrayList();
    private Train lastTrain = null;
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    RfidSystemConnectionMemo memo = null;
    protected JCheckBox showTimestamps = new JCheckBox();
    protected JCheckBox showDuplicates = new JCheckBox();
    protected JCheckBox forceSetCar = new JCheckBox();
    protected String timeCheck = this.getClass().getName() + "Times";
    protected String dupeCheck = this.getClass().getName() + "Duplicates";
    protected String forceSet = this.getClass().getName() + "ForceSet";
    protected JButton clearButton = new JButton();
    protected JLabel rowCountLabel = new JLabel();
    protected JTextField rowCount = new JTextField();
    protected JButton setRowCount = new JButton();
    protected String rowCountField = this.getClass().getName() + "RowCount";
    JLabel panelMessage = new JLabel("");

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return Bundle.getMessage("MonitorRFIDTagCars", "RFID Device") + " - " + this.memo.getSystemPrefix();
        }
        return Bundle.getMessage("MonitorRFIDTagCars", "RFID Device");
    }

    @Override
    public void message(RfidMessage m) {
        log.debug("got a new tag {}", (Object)m.toString());
    }

    @Override
    public void reply(RfidReply m) {
        log.debug("got a new Reply msg {}", (Object)m.toString());
        String thisTag = "ID" + this.memo.getProtocol().getTag(m);
        log.debug("This this tag is -{}-", (Object)thisTag);
        if (!this.showDuplicates.isSelected() && thisTag.equals(this.lastTagSeen)) {
            this.dataModel.setLast(LocalTime.now());
            return;
        }
        this.lastTagSeen = thisTag;
        this.createNewItem(thisTag);
    }

    private TagCarItem createNewItem(String tag) {
        TagCarItem newTag = new TagCarItem(tag, LocalTime.now());
        Car thisCar = (Car)this.carManager.getByRfid(tag);
        JButton action1Button = new JButton();
        JButton action2 = new JButton();
        newTag.setAction2(action2);
        newTag.setAction1(action1Button);
        if (thisCar != null) {
            newTag.setRoad(thisCar.getRoadName());
            newTag.setCarNumber(thisCar.getNumber());
            newTag.setCurrentCar(thisCar);
            action1Button.setText(Bundle.getMessage("MonitorSetLocation"));
            action1Button.setEnabled(false);
            action1Button.setToolTipText(Bundle.getMessage("MonitorSetLocToolTip"));
            action2.setText(Bundle.getMessage("MonitorEditCar"));
            action2.setToolTipText(Bundle.getMessage("MonitorEditToolTip"));
            action2.setEnabled(true);
            if (thisCar.getTrainName() != null) {
                newTag.setTrain(thisCar.getTrainName());
                newTag.setTrainPosition(this.getCarTrainPosition(thisCar, thisCar.getTrain()));
            }
        } else {
            action1Button.setText(Bundle.getMessage("MonitorAssociate"));
            action1Button.setToolTipText(Bundle.getMessage("MonitorAssociateToolTip"));
            action2.setText("");
            action1Button.setEnabled(true);
            action2.setEnabled(false);
        }
        this.dataModel.add(newTag);
        return newTag;
    }

    public int getCarTrainPosition(RollingStock thisCar, Train thisTrain) {
        String carRoad = thisCar.getRoadName();
        String carNumber = thisCar.getNumber();
        if (thisTrain == null) {
            log.debug("train is null in getCarTrainPosition");
            return 0;
        }
        log.debug("finding car {} {} in Train {}", new Object[]{carRoad, carNumber, thisTrain.getName()});
        if (!thisTrain.equals(this.lastTrain)) {
            log.debug("new train - retrieving it");
            this.lastTrain = thisTrain;
            this.lastTrainCars.clear();
            this.lastTrainCars.addAll(this.carManager.getByTrainDestinationList(thisTrain));
        }
        int positionCounter = 0;
        for (RollingStock trainElement : this.lastTrainCars) {
            if (!(trainElement instanceof Car)) continue;
            ++positionCounter;
            if (!trainElement.equals(thisCar)) continue;
            return positionCounter;
        }
        log.error("Expected to find car {} {} in train {} and did not", new Object[]{carRoad, carNumber, thisTrain.getName()});
        return 0;
    }

    @Override
    public void initComponents(RfidSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addRfidListener(this);
        log.debug("added self as RFID listener");
    }

    @Override
    public void dispose() {
        UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
        pm.setSimplePreferenceState(this.timeCheck, this.showTimestamps.isSelected());
        pm.setSimplePreferenceState(this.dupeCheck, this.showDuplicates.isSelected());
        pm.setProperty(this.rowCountField, this.rowCountField, this.rowCount.getText());
        pm.setSimplePreferenceState(this.forceSet, this.forceSetCar.isSelected());
        super.dispose();
    }

    public void setMessageNormal(String newMessage) {
        this.panelMessage.setForeground(Color.BLACK);
        this.panelMessage.setText(newMessage);
    }

    public void setMessageError(String newMessage) {
        this.setForeground(Color.RED);
        this.panelMessage.setText(newMessage);
    }

    public boolean getShowTimestamps() {
        return this.showTimestamps.isSelected();
    }

    @Override
    public void initComponents() {
        this.dataModel = new TableDataModel(this);
        JTable tagMonitorTable = new JTable(this.dataModel);
        tagMonitorTable.setRowHeight(tagMonitorTable.getRowHeight() + 5);
        tagMonitorTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        tagMonitorTable.setSelectionMode(0);
        this.dataModel.setParent(tagMonitorTable);
        UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
        this.showTimestamps.setText(Bundle.getMessage("MonitorTimestamps"));
        this.showTimestamps.setVisible(true);
        this.showTimestamps.setToolTipText(Bundle.getMessage("MonitorTimeToolTip"));
        this.showTimestamps.setSelected(pm.getSimplePreferenceState(this.timeCheck));
        this.showDuplicates.setText(Bundle.getMessage("MonitorShowDupes"));
        this.showDuplicates.setVisible(true);
        this.showDuplicates.setToolTipText(Bundle.getMessage("MonitorDupesToolTip"));
        this.showDuplicates.setSelected(pm.getSimplePreferenceState(this.dupeCheck));
        this.forceSetCar.setText(Bundle.getMessage("MonitorForceSet"));
        this.forceSetCar.setSelected(pm.getSimplePreferenceState(this.forceSet));
        this.dataModel.showTimestamps = this.showTimestamps.isSelected();
        this.dataModel.setForceSetLocation(this.forceSetCar.isSelected());
        this.dataModel.initTable();
        this.setLayout(new BoxLayout(this, 1));
        JScrollPane tablePane = new JScrollPane(tagMonitorTable);
        tablePane.setPreferredSize(new Dimension(100, 400));
        tagMonitorTable.setFillsViewportHeight(true);
        this.add(tablePane);
        JmriPanel checkBoxPanel = new JmriPanel();
        JmriPanel messagePanel = new JmriPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        JLabel msgLabel = new JLabel(Bundle.getMessage("MonitorMessageLabel"));
        msgLabel.setPreferredSize(new Dimension(30, 15));
        messagePanel.add(msgLabel);
        this.panelMessage.setText("");
        this.panelMessage.setPreferredSize(new Dimension(170, 15));
        messagePanel.add(this.panelMessage);
        this.add(messagePanel);
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        this.clearButton.setText(Bundle.getMessage("ButtonClearScreen"));
        checkBoxPanel.add(this.clearButton);
        this.clearButton.addActionListener(e -> this.dataModel.clearTable());
        this.rowCountLabel.setText(Bundle.getMessage("MonitorRowCount"));
        checkBoxPanel.add(this.rowCountLabel);
        try {
            this.currentRowCount = Integer.valueOf(pm.getProperty(this.rowCountField, this.rowCountField).toString());
        }
        catch (NullPointerException nulls) {
            this.currentRowCount = 15;
        }
        this.dataModel.setRowMax(this.currentRowCount);
        checkBoxPanel.setPreferredSize(new Dimension(750, 30));
        checkBoxPanel.setMaximumSize(new Dimension(800, 30));
        this.rowCount.setPreferredSize(new Dimension(40, 15));
        this.rowCount.setMinimumSize(new Dimension(40, 12));
        this.rowCount.setText(this.currentRowCount.toString());
        checkBoxPanel.add(this.rowCount);
        checkBoxPanel.add(this.setRowCount);
        this.setRowCount.setText(Bundle.getMessage("MonitorSetRowCount"));
        this.setRowCount.setToolTipText(Bundle.getMessage("MonitorRowToolTip"));
        checkBoxPanel.add(this.showTimestamps);
        this.showTimestamps.setMinimumSize(new Dimension(60, 12));
        checkBoxPanel.add(this.showDuplicates);
        this.showDuplicates.setMinimumSize(new Dimension(60, 12));
        this.add(checkBoxPanel);
        this.rowCount.addActionListener(e -> {
            block5: {
                if (!this.rowCount.getText().isEmpty()) {
                    String text = this.rowCount.getText();
                    try {
                        int newValue = Integer.parseInt(text);
                        if (newValue > 0 && newValue < 100) {
                            this.setRowCount.setEnabled(true);
                            this.setMessageNormal("");
                            break block5;
                        }
                        this.setMessageError(Bundle.getMessage("MonitorRowCountError"));
                        this.setRowCount.setEnabled(false);
                    }
                    catch (NumberFormatException exception) {
                        this.setMessageError(Bundle.getMessage("MonitorRowCountError"));
                        this.setRowCount.setEnabled(false);
                    }
                } else {
                    this.setMessageNormal("");
                    this.setRowCount.setEnabled(false);
                }
            }
        });
        this.setRowCount.addActionListener(e -> {
            try {
                int newValue = Integer.parseInt(this.rowCount.getText());
                this.dataModel.setRowMax(newValue);
                this.setMessageNormal("");
            }
            catch (NumberFormatException exception) {
                this.setMessageError(Bundle.getMessage("MonitorRowCountError"));
                log.error("error interpreting new number of lines");
            }
        });
        ActionListener checkListener = e -> {
            if (e.getSource().equals(this.showTimestamps)) {
                this.dataModel.showTimestamps(this.showTimestamps.isSelected());
                log.debug("switching show timestamps now");
            } else if (e.getSource().equals(this.showDuplicates)) {
                log.debug("changing show duplicates now");
            }
        };
        this.showDuplicates.addActionListener(checkListener);
        this.showTimestamps.addActionListener(checkListener);
        this.dataModel.addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        block2: {
            int column;
            block3: {
                if (e.getType() != 0) break block2;
                log.debug("table was updated");
                column = e.getColumn();
                if (column != 4) break block3;
                log.debug("Location was changed");
                for (int thisRow = e.getFirstRow(); thisRow <= e.getLastRow(); ++thisRow) {
                    log.debug("Updated location column row {}", (Object)thisRow);
                }
                break block2;
            }
            if (column != 5) break block2;
            for (int thisRow = e.getFirstRow(); thisRow <= e.getLastRow(); ++thisRow) {
                log.debug("Track column row {}", (Object)thisRow);
            }
        }
    }
}

