/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco;

import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetThrottleManager;
import jmri.jmrix.roco.Bundle;
import jmri.jmrix.roco.RocoXNetThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocoXNetThrottleManager
extends XNetThrottleManager {
    private static final Logger log = LoggerFactory.getLogger(RocoXNetThrottleManager.class);

    public RocoXNetThrottleManager(XNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (this.tc.getCommandStation().getCommandStationType() == 4 && address.getNumber() >= 100) {
            String typeString = Bundle.getMessage("CSTypeLokMaus");
            this.failedThrottleRequest(address, Bundle.getMessage("ThrottleErrorCSTwoDigit", typeString));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Requesting Throttle: {}", (Object)address);
        }
        if (this.throttles.containsKey(address)) {
            this.notifyThrottleKnown((DccThrottle)this.throttles.get(address), address);
        } else {
            RocoXNetThrottle throttle = new RocoXNetThrottle((XNetSystemConnectionMemo)this.adapterMemo, address, this.tc);
            this.throttles.put(address, throttle);
            this.notifyThrottleKnown(throttle, address);
        }
    }
}

