/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.jmrix.roco.RocoCommandStation;

public class RocoZ21CommandStation
extends RocoCommandStation {
    private static final int XPressNetFlag = 1;
    private static final int RMBusFlag = 2;
    private static final int RailComFlag = 4;
    private static final int SystemStateFlag = 256;
    private static final int XPressNetLocomotiveFlag = 65536;
    private static final int LocoNetDataFlag = 0x1000000;
    private static final int LocoNetLocomotiveFlag = 0x2000000;
    private static final int LocoNetTurnoutFlag = 0x4000000;
    private static final int LocoNetOccupancyFlag = 0x8000000;
    private static final int AutoMaticRailComFlag = 262144;
    private static final int CANDetectorFlag = 524288;
    private static final int CANBoosterFlag = 131072;
    private static final int FastClockFlag = 16;
    private int broadcast_flags = 0;
    private int serial_number = 0;
    private float software_version = 0.0f;
    private int hardware_version = 0;

    public int getSerialNumber() {
        return this.serial_number;
    }

    public void setSerialNumber(int sn) {
        this.serial_number = sn;
    }

    public float getSoftwareVersion() {
        return this.software_version;
    }

    public void setSoftwareVersion(float sv) {
        this.software_version = sv;
    }

    public int getHardwareVersion() {
        return this.hardware_version;
    }

    public void setHardwareVersion(int hv) {
        this.hardware_version = hv;
    }

    public int getZ21BroadcastFlags() {
        return this.broadcast_flags;
    }

    public void setZ21BroadcastFlags(int flags) {
        this.broadcast_flags = flags;
    }

    public String getZ21BroadcastFlagsString() {
        return RocoZ21CommandStation.getZ21BroadcastFlagsString(this.broadcast_flags);
    }

    public static String getZ21BroadcastFlagsString(int flags) {
        StringBuilder flagStringBuilder = new StringBuilder();
        if ((flags & 1) == 1) {
            flagStringBuilder.append("XpressNet Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 2) == 2) {
            flagStringBuilder.append("RMBus Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 4) == 4) {
            flagStringBuilder.append("Railcom Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x100) == 256) {
            flagStringBuilder.append("System State Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x10000) == 65536) {
            flagStringBuilder.append("XpressNet Locomotive Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x1000000) == 0x1000000) {
            flagStringBuilder.append("LocoNet Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x2000000) == 0x2000000) {
            flagStringBuilder.append("LocoNet Locomotive Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x4000000) == 0x4000000) {
            flagStringBuilder.append("LocoNet Turnout Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x8000000) == 0x8000000) {
            flagStringBuilder.append("LocoNet Occupancy Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x40000) == 262144) {
            flagStringBuilder.append("Railcom Automatic Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x80000) == 524288) {
            flagStringBuilder.append("CAN Detector Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x20000) == 131072) {
            flagStringBuilder.append("CAN Booster Status Messages");
            flagStringBuilder.append("\n");
        }
        if ((flags & 0x10) == 16) {
            flagStringBuilder.append("Fast Clock Messages");
            flagStringBuilder.append("\n");
        }
        return flagStringBuilder.toString();
    }

    public boolean getXPressNetMessagesFlag() {
        return (this.broadcast_flags & 1) == 1;
    }

    public void setXPressNetMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 1) : (this.broadcast_flags &= 0xFFFFFFFE);
    }

    public boolean getRMBusMessagesFlag() {
        return (this.broadcast_flags & 2) == 2;
    }

    public void setRMBusMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 2) : (this.broadcast_flags &= 0xFFFFFFFD);
    }

    public boolean getRailComMessagesFlag() {
        return (this.broadcast_flags & 4) == 4;
    }

    public void setRailComMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 4) : (this.broadcast_flags &= 0xFFFFFFFB);
    }

    public boolean getRailComAutomaticFlag() {
        return (this.broadcast_flags & 0x40000) == 262144;
    }

    public void setRailComAutomaticFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x40000) : (this.broadcast_flags &= 0xFFFBFFFF);
    }

    public boolean getCanDetectorFlag() {
        return (this.broadcast_flags & 0x80000) == 524288;
    }

    public void setCanDetectorFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x80000) : (this.broadcast_flags &= 0xFFF7FFFF);
    }

    public boolean getCanBoosterFlag() {
        return (this.broadcast_flags & 0x20000) == 131072;
    }

    public void setCanBoosterFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x20000) : (this.broadcast_flags &= 0xFFFDFFFF);
    }

    public boolean getSystemStatusMessagesFlag() {
        return (this.broadcast_flags & 0x100) == 256;
    }

    public void setSystemStatusMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x100) : (this.broadcast_flags &= 0xFFFFFEFF);
    }

    public boolean getXPressNetLocomotiveMessagesFlag() {
        return (this.broadcast_flags & 0x10000) == 65536;
    }

    public void setXPressNetLocomotiveMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x10000) : (this.broadcast_flags &= 0xFFFEFFFF);
    }

    public boolean getLocoNetMessagesFlag() {
        return (this.broadcast_flags & 0x1000000) == 0x1000000;
    }

    public void setLocoNetMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x1000000) : (this.broadcast_flags &= 0xFEFFFFFF);
    }

    public boolean getLocoNetLocomotiveMessagesFlag() {
        return (this.broadcast_flags & 0x2000000) == 0x2000000;
    }

    public void setLocoNetLocomotiveMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x2000000) : (this.broadcast_flags &= 0xFDFFFFFF);
    }

    public boolean getLocoNetTurnoutMessagesFlag() {
        return (this.broadcast_flags & 0x4000000) == 0x4000000;
    }

    public void setLocoNetTurnoutMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x4000000) : (this.broadcast_flags &= 0xFBFFFFFF);
    }

    public boolean getLocoNetOccupancyMessagesFlag() {
        return (this.broadcast_flags & 0x8000000) == 0x8000000;
    }

    public void setLocoNetOccupancyMessagesFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x8000000) : (this.broadcast_flags &= 0xF7FFFFFF);
    }

    public boolean getFastClockFlag() {
        return (this.broadcast_flags & 0x10) == 16;
    }

    public void setFastClockFlag(boolean flag) {
        this.broadcast_flags = flag ? (this.broadcast_flags |= 0x10) : (this.broadcast_flags &= 0xFFFFFFEF);
    }
}

