/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ResourceBundle;
import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21Adapter
extends AbstractNetworkPortController {
    protected static ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.roco.z21.z21AdapterConfigurationBundle");
    protected static int COMMUNICATION_UDP_PORT = Integer.parseInt(rb.getString("z21UDPPort1"));
    protected static String DEFAULT_IP_ADDRESS = rb.getString("defaultZ21IPAddress");
    private DatagramSocket socket = null;
    private static final Logger log = LoggerFactory.getLogger(Z21Adapter.class);

    public Z21Adapter() {
        super(new Z21SystemConnectionMemo());
        this.setHostName(DEFAULT_IP_ADDRESS);
        this.setPort(COMMUNICATION_UDP_PORT);
        this.allowConnectionRecovery = true;
    }

    @Override
    public void configure() {
        if (log.isDebugEnabled()) {
            log.debug("configure called");
        }
        Z21TrafficController packets = new Z21TrafficController();
        packets.connectPort(this);
        this.getSystemConnectionMemo().setTrafficController(packets);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public void connect() throws IOException {
        this.opened = false;
        if (this.getHostAddress() == null || this.m_port == 0) {
            log.error("No host name or port set : {}:{}", (Object)this.m_HostName, (Object)this.m_port);
            return;
        }
        try {
            this.socket = new DatagramSocket();
            this.opened = true;
        }
        catch (SocketException se) {
            log.error("Socket Exception creating connection.");
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName, "Not Connected");
            }
            throw se;
        }
        if (this.opened && this.m_port != 0) {
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName + ":" + this.m_port, "Connected");
        } else if (this.opened) {
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName, "Connected");
        }
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public Z21SystemConnectionMemo getSystemConnectionMemo() {
        return (Z21SystemConnectionMemo)super.getSystemConnectionMemo();
    }

    @Override
    protected void resetupConnection() {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.opened) {
            this.socket.close();
        }
        this.opened = false;
        this.allowConnectionRecovery = false;
    }
}

