/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.ArrayList;
import java.util.Collection;
import jmri.CollectingReporter;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.AbstractRailComReporter;
import jmri.jmrix.roco.z21.Z21CanBusAddress;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21MessageUtils;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21CanReporter
extends AbstractRailComReporter
implements Z21Listener,
CollectingReporter {
    private Z21SystemConnectionMemo _memo;
    private int networkID = 0;
    private int moduleAddress = -1;
    private int port;
    private ArrayList<Object> idTags;
    private static final Logger log = LoggerFactory.getLogger(Z21CanReporter.class);

    public Z21CanReporter(String systemName, String userName, Z21SystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this._memo.getTrafficController().addz21Listener(this);
        try {
            this.setIdentifiersFromSystemName(systemName);
        }
        catch (NumberFormatException ex) {
            log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)systemName);
            throw new IllegalArgumentException("requires mm:pp format address.");
        }
        this.idTags = new ArrayList();
    }

    private void setIdentifiersFromSystemName(String systemName) {
        String moduleAddressText = Z21CanBusAddress.getEncoderAddressString(systemName, this._memo.getSystemPrefix());
        try {
            this.moduleAddress = Integer.parseInt(moduleAddressText);
        }
        catch (NumberFormatException ex) {
            this.networkID = Integer.parseInt(moduleAddressText, 16);
        }
        this.port = Z21CanBusAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
    }

    @Override
    public void reply(Z21Reply msg) {
        if (msg.isCanReporterMessage()) {
            int msgPort;
            int netID = (msg.getElement(4) & 0xFF) + ((msg.getElement(5) & 0xFF) << 8);
            int address = (msg.getElement(6) & 0xFF) + ((msg.getElement(7) & 0xFF) << 8);
            if (!this.messageForReporter(address, netID, msgPort = msg.getElement(8) & 0xFF)) {
                return;
            }
            int type = msg.getElement(9) & 0xFF;
            if (type == 17) {
                log.trace("clear list, size {}", (Object)this.idTags.size());
                this.idTags.clear();
                this.notify(null);
            }
            int value1 = (msg.getElement(10) & 0xFF) + ((msg.getElement(11) & 0xFF) << 8);
            int value2 = (msg.getElement(12) & 0xFF) + ((msg.getElement(13) & 0xFF) << 8);
            RailCom tag = this.getRailComTagFromValue(value1);
            if (tag != null) {
                log.trace("add tag {}", (Object)tag);
                this.notify(tag);
                this.idTags.add(tag);
                tag = this.getRailComTagFromValue(value2);
                if (tag != null) {
                    log.trace("add tag {} ", (Object)tag);
                    this.notify(tag);
                    this.idTags.add(tag);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("after message, new list size {}", (Object)this.idTags.size());
                int i = 0;
                for (Object id : this.idTags) {
                    log.debug("tag {}: {}", (Object)i++, id);
                }
            }
        }
    }

    private boolean messageForReporter(int address, int netId, int msgPort) {
        return (address == this.moduleAddress || netId == this.networkID) && msgPort == this.port;
    }

    private RailCom getRailComTagFromValue(int value) {
        DccLocoAddress l = Z21MessageUtils.getCanDetectorLocoAddress(value);
        if (l != null) {
            log.debug("reporting tag for address 1 {}", (Object)l);
            RailCom tag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + l.getNumber());
            int direction = 0xC000 & value;
            switch (direction) {
                case 32768: {
                    tag.setOrientation(16);
                    break;
                }
                case 49152: {
                    tag.setOrientation(32);
                    break;
                }
                default: {
                    tag.setOrientation(0);
                }
            }
            return tag;
        }
        return null;
    }

    @Override
    public void message(Z21Message msg) {
    }

    @Override
    public Collection<Object> getCollection() {
        return this.idTags;
    }
}

