/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.implementation.AbstractSensor;
import jmri.jmrix.roco.z21.Z21CanBusAddress;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21CanSensor
extends AbstractSensor
implements Z21Listener {
    private Z21SystemConnectionMemo _memo;
    private int networkID = 0;
    private int moduleAddress = -1;
    private int port;
    private static final Logger log = LoggerFactory.getLogger(Z21CanSensor.class);

    public Z21CanSensor(String systemName, String userName, Z21SystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this._memo.getTrafficController().addz21Listener(this);
        try {
            this.setIdentifiersFromSystemName(systemName);
        }
        catch (NumberFormatException ex) {
            log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)systemName);
            throw new IllegalArgumentException("requires mm:pp format address.");
        }
    }

    private void setIdentifiersFromSystemName(String systemName) {
        String moduleAddressText = Z21CanBusAddress.getEncoderAddressString(systemName, this._memo.getSystemPrefix());
        try {
            this.moduleAddress = Integer.parseInt(moduleAddressText);
        }
        catch (NumberFormatException ex) {
            this.networkID = Integer.parseInt(moduleAddressText, 16);
        }
        this.port = Z21CanBusAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.networkID == 0) {
            return;
        }
        this._memo.getTrafficController().sendz21Message(Z21Message.getLanCanDetector(this.networkID), this);
    }

    @Override
    public void reply(Z21Reply msg) {
        if (msg.isCanSensorMessage()) {
            int msgPort;
            int netID = (msg.getElement(4) & 0xFF) + ((msg.getElement(5) & 0xFF) << 8);
            int address = (msg.getElement(6) & 0xFF) + ((msg.getElement(7) & 0xFF) << 8);
            if (!this.messageForSensor(address, netID, msgPort = msg.getElement(8) & 0xFF)) {
                return;
            }
            int value1 = (msg.getElement(10) & 0xFF) + ((msg.getElement(11) & 0xFF) << 8);
            log.debug("value {}", (Object)value1);
            if (value1 == 0) {
                log.debug("Free without voltage");
                this.setOwnState(4);
            } else if (value1 == 256) {
                log.debug("Free with voltage");
                this.setOwnState(4);
            } else if (value1 == 4096) {
                log.debug("Busy without voltage");
                this.setOwnState(2);
            } else if (value1 == 4352) {
                log.debug("Busy with voltage");
                this.setOwnState(2);
            } else if (value1 == 4609) {
                log.debug("Busy Overload 1");
                this.setOwnState(2);
            } else if (value1 == 4610) {
                log.debug("Busy Overload 2");
                this.setOwnState(2);
            } else if (value1 == 4611) {
                log.debug("Busy Overload 3");
                this.setOwnState(2);
            }
        }
    }

    private boolean messageForSensor(int address, int netId, int msgPort) {
        return (address == this.moduleAddress || netId == this.networkID) && msgPort == this.port;
    }

    @Override
    public void message(Z21Message msg) {
    }

    @Override
    public void dispose() {
        this._memo.getTrafficController().removez21Listener(this);
        super.dispose();
    }
}

