/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.streamport.LnStreamPortController;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21LnStreamPortController;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21TrafficController;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21LocoNetTunnel
implements Z21Listener,
LocoNetListener,
Runnable {
    LnStreamPortController lsc = null;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private final Z21SystemConnectionMemo _memo;
    private Thread sourceThread;
    private volatile boolean stopThread = false;
    private static final Logger log = LoggerFactory.getLogger(Z21LocoNetTunnel.class);

    public Z21LocoNetTunnel(Z21SystemConnectionMemo memo) {
        this._memo = memo;
        this.init();
    }

    private void init() {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
            return;
        }
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("z21.Z21LocoNetTunnel sourceThread");
        this.sourceThread.setDaemon(true);
        this.sourceThread.start();
        LocoNetSystemConnectionMemo lnMemo = new LocoNetSystemConnectionMemo();
        this.setStreamPortController(new Z21LnStreamPortController(lnMemo, this.pin, this.pout, "None"));
        this._memo.getTrafficController().addz21Listener(this);
        this.lsc.configure();
    }

    @Override
    public void run() {
        log.debug("LocoNet Tunnel Thread Started");
        while (!this.stopThread) {
            LocoNetMessage m = this.readMessage();
            if (m == null) continue;
            this.message(m);
        }
    }

    private LocoNetMessage readMessage() {
        LocoNetMessage msg = null;
        try {
            msg = this.loadChars();
        }
        catch (IOException | LocoNetMessageException exception) {
            // empty catch block
        }
        return msg;
    }

    private LocoNetMessage loadChars() throws IOException, LocoNetMessageException {
        int opCode;
        while (((opCode = this.readByteProtected(this.inpipe) & 0xFF) & 0x80) == 0) {
            log.trace("Skipping: {}", (Object)Integer.toHexString(opCode));
        }
        log.trace(" (RcvHandler) Start message with opcode: {}", (Object)Integer.toHexString(opCode));
        LocoNetMessage msg = null;
        while (msg == null) {
            try {
                int byte2 = this.readByteProtected(this.inpipe) & 0xFF;
                log.trace("Byte2: {}", (Object)Integer.toHexString(byte2));
                int len = 2;
                switch ((opCode & 0x60) >> 5) {
                    case 0: {
                        len = 2;
                        break;
                    }
                    case 1: {
                        len = 4;
                        break;
                    }
                    case 2: {
                        len = 6;
                        break;
                    }
                    case 3: {
                        if (byte2 < 2) {
                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                        }
                        len = byte2;
                        break;
                    }
                    default: {
                        log.warn("Unhandled code: {}", (Object)((opCode & 0x60) >> 5));
                    }
                }
                msg = new LocoNetMessage(len);
                msg.setOpCode(opCode);
                msg.setElement(1, byte2);
                log.trace("len: {}", (Object)len);
                for (int i = 2; i < len; ++i) {
                    int b = this.readByteProtected(this.inpipe) & 0xFF;
                    log.trace("char {} is: {}", (Object)i, (Object)Integer.toHexString(b));
                    if ((b & 0x80) != 0) {
                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                        opCode = b;
                        throw new LocoNetMessageException();
                    }
                    msg.setElement(i, b);
                }
            }
            catch (LocoNetMessageException e) {
                msg = null;
            }
        }
        if (!msg.checkParity()) {
            log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg);
            throw new LocoNetMessageException();
        }
        return msg;
    }

    private byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        byte[] rcvBuffer = new byte[1];
        while ((nchars = istream.read(rcvBuffer, 0, 1)) <= 0) {
        }
        return rcvBuffer[0];
    }

    @Override
    public void reply(Z21Reply msg) {
        if (msg.isLocoNetTunnelMessage()) {
            LocoNetMessage reply = msg.getLocoNetMessage();
            log.debug("Z21 Reply {} forwarded to XpressNet implementation as {}", (Object)msg, (Object)reply);
            for (int i = 0; i < reply.getNumDataElements(); ++i) {
                try {
                    this.outpipe.writeByte(reply.getElement(i));
                    continue;
                }
                catch (IOException ioe) {
                    log.error("Error writing XpressNet Reply to XpressNet input stream.");
                }
            }
        }
    }

    @Override
    public void message(Z21Message msg) {
    }

    @Override
    public void message(LocoNetMessage msg) {
        Z21Message message = new Z21Message(msg);
        log.debug("LocoNet Message {} forwarded to z21 Interface as {}", (Object)msg, (Object)message);
        this._memo.getTrafficController().sendz21Message(message, this);
    }

    LnStreamPortController getStreamPortController() {
        return this.lsc;
    }

    void setStreamPortController(LnStreamPortController x) {
        this.lsc = x;
        this.lsc.getSystemConnectionMemo().setSystemPrefix("L");
        this.lsc.getSystemConnectionMemo().setUserName(this._memo.getUserName() + "LocoNet");
    }

    public void dispose() {
        Z21TrafficController tc;
        if (this.sourceThread != null) {
            this.stopThread = true;
            this.sourceThread.interrupt();
            try {
                this.sourceThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.lsc != null) {
            this.lsc.dispose();
        }
        if (this._memo != null && (tc = this._memo.getTrafficController()) != null) {
            tc.removez21Listener(this);
        }
        try {
            this.inpipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

