/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Meter;
import jmri.MeterManager;
import jmri.implementation.DefaultMeter;
import jmri.implementation.MeterUpdateTask;
import jmri.jmrix.roco.z21.RocoZ21CommandStation;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21PredefinedMeters {
    private Z21TrafficController tc;
    private Z21SystemConnectionMemo _memo;
    private final MeterUpdateTask updateTask;
    private final Meter currentMeter;
    private final Meter voltageMeter;
    private boolean enabled = false;
    private static final Logger log = LoggerFactory.getLogger(Z21PredefinedMeters.class);

    public Z21PredefinedMeters(Z21SystemConnectionMemo memo) {
        this._memo = memo;
        this.tc = this._memo.getTrafficController();
        this.updateTask = new UpdateTask(-1);
        this.currentMeter = new DefaultMeter.DefaultCurrentMeter(memo.getSystemPrefix() + "VCommandStationCurrent", Meter.Unit.Milli, 0.0, 10000.0, 100.0, this.updateTask);
        this.voltageMeter = new DefaultMeter.DefaultVoltageMeter(memo.getSystemPrefix() + "VCommandStationVoltage", Meter.Unit.Milli, 0.0, 50000.0, 500.0, this.updateTask);
        InstanceManager.getDefault(MeterManager.class).register(this.currentMeter);
        InstanceManager.getDefault(MeterManager.class).register(this.voltageMeter);
        log.debug("Z21MultiMeter constructor called");
    }

    public void setZ21TrafficController(Z21TrafficController controller) {
        this.tc = controller;
    }

    public void dispose() {
        this.updateTask.disable(this.currentMeter);
        this.updateTask.disable(this.voltageMeter);
        InstanceManager.getDefault(MeterManager.class).deregister(this.currentMeter);
        InstanceManager.getDefault(MeterManager.class).deregister(this.voltageMeter);
        this.updateTask.dispose(this.currentMeter);
        this.updateTask.dispose(this.voltageMeter);
    }

    private class UpdateTask
    extends MeterUpdateTask
    implements Z21Listener {
        public UpdateTask(int interval) {
            super(interval);
            Z21PredefinedMeters.this.tc.addz21Listener(this);
        }

        @Override
        public void enable() {
            Z21PredefinedMeters.this.enabled = true;
            RocoZ21CommandStation cs = Z21PredefinedMeters.this._memo.getRocoZ21CommandStation();
            cs.setSystemStatusMessagesFlag(true);
            Z21PredefinedMeters.this.tc.sendz21Message(Z21Message.getLanSetBroadcastFlagsRequestMessage(cs.getZ21BroadcastFlags()), this);
            super.enable();
        }

        @Override
        public void disable() {
            if (!Z21PredefinedMeters.this.enabled) {
                return;
            }
            super.disable();
            Z21PredefinedMeters.this.enabled = false;
            RocoZ21CommandStation cs = Z21PredefinedMeters.this._memo.getRocoZ21CommandStation();
            cs.setSystemStatusMessagesFlag(false);
            Z21PredefinedMeters.this.tc.sendz21Message(Z21Message.getLanSetBroadcastFlagsRequestMessage(cs.getZ21BroadcastFlags()), this);
        }

        @Override
        public void message(Z21Message m) {
        }

        @Override
        public void reply(Z21Reply r) {
            log.debug("Z21MultiMeter received reply: {}", (Object)r.toString());
            if (r.isSystemDataChangedReply()) {
                try {
                    this.setCurrent((float)r.getSystemDataMainCurrent() * 1.0f);
                    this.setVoltage((float)r.getSystemDataVCCVoltage() * 1.0f);
                }
                catch (JmriException e) {
                    log.error("exception thrown by setCurrent or setVoltage", (Throwable)e);
                }
            }
        }

        private void setCurrent(double value) throws JmriException {
            Z21PredefinedMeters.this.currentMeter.setCommandedAnalogValue(value);
        }

        private void setVoltage(double value) throws JmriException {
            Z21PredefinedMeters.this.voltageMeter.setCommandedAnalogValue(value);
        }

        @Override
        public void requestUpdateFromLayout() {
            if (Z21PredefinedMeters.this.enabled) {
                Z21PredefinedMeters.this.tc.sendz21Message(Z21Message.getLanSystemStateDataChangedRequestMessage(), this);
            }
        }
    }
}

