/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.implementation.AbstractSensor;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21RMBusAddress;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21RMBusSensor
extends AbstractSensor
implements Z21Listener {
    private boolean statusRequested = false;
    private int address;
    private int moduleAddress;
    private int bit;
    private String systemName;
    protected Z21TrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(Z21RMBusSensor.class);

    public Z21RMBusSensor(String systemName, String userName, Z21TrafficController controller, String prefix) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName, prefix);
    }

    public Z21RMBusSensor(String systemName, Z21TrafficController controller, String prefix) {
        super(systemName);
        this.tc = controller;
        this.init(systemName, prefix);
    }

    private void init(String id, String prefix) {
        this.systemName = id;
        this.address = Z21RMBusAddress.getBitFromSystemName(this.systemName, prefix);
        this.moduleAddress = (this.address - 1) / 8;
        int bitnumber = (this.address - 1) % 8;
        switch (bitnumber) {
            case 0: {
                this.bit = 1;
                break;
            }
            case 1: {
                this.bit = 2;
                break;
            }
            case 2: {
                this.bit = 4;
                break;
            }
            case 3: {
                this.bit = 8;
                break;
            }
            case 4: {
                this.bit = 16;
                break;
            }
            case 5: {
                this.bit = 32;
                break;
            }
            case 6: {
                this.bit = 64;
                break;
            }
            case 7: {
                this.bit = 128;
                break;
            }
        }
        log.debug("Created Sensor {} (Module Address {},  contact {})", new Object[]{this.systemName, this.moduleAddress, bitnumber});
        this.tc.addz21Listener(this);
        this.requestUpdateFromLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestUpdateFromLayout() {
        Z21Message msg = Z21Message.getLanRMBusGetDataRequestMessage(this.moduleAddress <= 10 ? 0 : 1);
        Z21RMBusSensor z21RMBusSensor = this;
        synchronized (z21RMBusSensor) {
            this.statusRequested = true;
        }
        this.tc.sendz21Message(msg, this);
    }

    synchronized void initmessage(Z21Reply l) {
        boolean oldState = this.statusRequested;
        this.reply(l);
        this.statusRequested = oldState;
    }

    @Override
    public synchronized void reply(Z21Reply l) {
        log.debug("received message: {}", (Object)l);
        if (l.isRMBusDataChangedReply()) {
            if ((l.getElement(this.moduleAddress < 10 ? 5 + this.moduleAddress : 5 + (this.moduleAddress - 10)) & this.bit) != 0 ^ this._inverted) {
                this.setOwnState(2);
            } else {
                this.setOwnState(4);
            }
        }
    }

    @Override
    public void message(Z21Message l) {
    }

    @Override
    public void dispose() {
        this.tc.removez21Listener(this);
        super.dispose();
    }

    int getNumber() {
        return this.address;
    }

    int getModuleAddress() {
        return this.moduleAddress;
    }
}

