/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.DccLocoAddress;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.roco.z21.Z21MessageFormatter;
import jmri.jmrix.roco.z21.Z21MessageUtils;
import jmri.jmrix.roco.z21.Z21XNetReply;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21Reply
extends AbstractMRReply {
    private static final String WRONG_REPLY_TYPE = "Wrong Reply Type";
    private static List<Z21MessageFormatter> formatterList = new ArrayList<Z21MessageFormatter>();
    private static final Logger log = LoggerFactory.getLogger(Z21Reply.class);

    public Z21Reply() {
        this.setBinary(true);
    }

    public Z21Reply(byte[] a, int l) {
        this._nDataChars = l;
        this.setBinary(true);
        for (int i = 0; i < this._nDataChars; ++i) {
            this._dataChars[i] = a[i];
        }
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = (char)v;
        this._nDataChars = Math.max(this._nDataChars, n + 1);
    }

    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    @Override
    public void setOpCode(int i) {
        this._dataChars[2] = (char)(i & 0xFF);
        this._dataChars[3] = (char)((i & 0xFF00) >> 8);
        this._nDataChars = Math.max(this._nDataChars, 4);
    }

    @Override
    public int getOpCode() {
        return (0xFF & this._dataChars[2]) + ((0xFF & this._dataChars[3]) << 8);
    }

    public void setLength(int i) {
        this._dataChars[0] = (char)(i & 0xFF);
        this._dataChars[1] = (char)((i & 0xFF00) >> 8);
        this._nDataChars = Math.max(this._nDataChars, i);
    }

    public int getLength() {
        return (0xFF & this._dataChars[0]) + ((0xFF & this._dataChars[1]) << 8);
    }

    @Override
    protected int skipPrefix(int index) {
        return 0;
    }

    @Override
    public String toMonitorString() {
        if (formatterList.isEmpty()) {
            try {
                Reflections reflections = new Reflections("jmri.jmrix.roco.z21.messageformatters", new Scanner[0]);
                Set f2 = reflections.getSubTypesOf(Z21MessageFormatter.class);
                for (Class c : f2) {
                    log.debug("Found formatter: {}", (Object)f2.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    formatterList.add((Z21MessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
        return formatterList.stream().filter(f -> f.handlesMessage(this)).findFirst().map(f -> f.formatMessage(this)).orElse(this.toString());
    }

    boolean isXPressNetTunnelMessage() {
        return this.getOpCode() == 64;
    }

    public Z21XNetReply getXNetReply() {
        Z21XNetReply xnr = null;
        if (this.isXPressNetTunnelMessage()) {
            int i;
            xnr = new Z21XNetReply();
            for (i = 4; i < this.getLength(); ++i) {
                xnr.setElement(i - 4, this.getElement(i));
            }
            if ((xnr.getElement(0) & 0xF) > xnr.getNumDataElements() + 2) {
                i -= 4;
                while (i < (xnr.getElement(0) & 0xF) + 2) {
                    xnr.setElement(i, 0);
                    ++i;
                }
            }
        }
        return xnr;
    }

    boolean isRailComDataChangedMessage() {
        return this.getOpCode() == 136;
    }

    public int getNumRailComDataEntries() {
        if (!this.isRailComDataChangedMessage()) {
            return 0;
        }
        return (this.getLength() - 4) / 13;
    }

    public DccLocoAddress getRailComLocoAddress(int n) {
        int address;
        int offset = 4 + n * 13;
        return new DccLocoAddress(address, (address = Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset)) >= 100);
    }

    public int getRailComRcvCount(int n) {
        int offset = 6 + n * 13;
        return ((0xFF & this.getElement(offset + 3)) << 24) + ((0xFF & this.getElement(offset + 2) << 16) + ((0xFF & this.getElement(offset + 1)) << 8) + (0xFF & this.getElement(offset)));
    }

    public int getRailComErrCount(int n) {
        int offset = 10 + n * 13;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    public int getRailComSpeed(int n) {
        int options = this.getRailComOptions(n);
        if ((options & 1) == 1 || (options & 2) == 2) {
            int offset = 14 + n * 13;
            return 0xFF & this.getElement(offset);
        }
        return 0;
    }

    public int getRailComOptions(int n) {
        int offset = 13 + n * 13;
        return 0xFF & this.getElement(offset);
    }

    public int getRailComQos(int n) {
        if ((this.getRailComOptions(n) & 4) == 4) {
            int offset = 15 + n * 13;
            return 0xFF & this.getElement(offset);
        }
        return 0;
    }

    boolean isSystemDataChangedReply() {
        return this.getOpCode() == 132;
    }

    private void checkSystemDataChangeReply() {
        if (!this.isSystemDataChangedReply()) {
            throw new IllegalArgumentException(WRONG_REPLY_TYPE);
        }
    }

    public int getSystemDataMainCurrent() {
        this.checkSystemDataChangeReply();
        int offset = 4;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    public int getSystemDataProgCurrent() {
        this.checkSystemDataChangeReply();
        int offset = 6;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    public int getSystemDataFilteredMainCurrent() {
        this.checkSystemDataChangeReply();
        int offset = 8;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    public int getSystemDataTemperature() {
        this.checkSystemDataChangeReply();
        int offset = 10;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    public int getSystemDataSupplyVoltage() {
        this.checkSystemDataChangeReply();
        int offset = 12;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    public int getSystemDataVCCVoltage() {
        this.checkSystemDataChangeReply();
        int offset = 14;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    boolean isLocoNetTunnelMessage() {
        switch (this.getOpCode()) {
            case 160: 
            case 161: 
            case 162: {
                return true;
            }
        }
        return false;
    }

    boolean isLocoNetDispatchMessage() {
        return this.getOpCode() == 163;
    }

    boolean isLocoNetDetectorMessage() {
        return this.getOpCode() == 164;
    }

    public LocoNetMessage getLocoNetMessage() {
        LocoNetMessage lnr = null;
        if (this.isLocoNetTunnelMessage()) {
            lnr = new LocoNetMessage(this.getLength() - 4);
            for (int i = 4; i < this.getLength(); ++i) {
                lnr.setElement(i - 4, this.getElement(i));
            }
        }
        return lnr;
    }

    boolean isRMBusDataChangedReply() {
        return this.getOpCode() == 128;
    }

    boolean isCanDetectorMessage() {
        return this.getOpCode() == 196;
    }

    public int canDetectorMessageType() {
        if (this.isCanDetectorMessage()) {
            return this.getElement(9) & 0xFF;
        }
        return -1;
    }

    public boolean isCanSensorMessage() {
        return this.isCanDetectorMessage() && this.canDetectorMessageType() == 1;
    }

    public boolean isCanReporterMessage() {
        int type = this.canDetectorMessageType();
        return this.isCanDetectorMessage() && type >= 17 && type <= 31;
    }
}

