/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import javax.swing.Timer;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.AbstractRailComReporter;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;

public class Z21Reporter
extends AbstractRailComReporter
implements Z21Listener {
    private Z21SystemConnectionMemo _memo;
    private Timer refreshTimer;
    private static final int refreshTimeoutValue = 15000;

    public Z21Reporter(String systemName, String userName, Z21SystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this._memo.getTrafficController().addz21Listener(this);
        this.requestUpdateFromLayout();
        this.refreshTimer();
    }

    private void requestUpdateFromLayout() {
        this._memo.getTrafficController().sendz21Message(Z21Message.getLanRailComGetDataRequestMessage(), this);
    }

    @Override
    public void reply(Z21Reply msg) {
        if (msg.isRailComDataChangedMessage()) {
            int tags = msg.getNumRailComDataEntries();
            for (int i = 0; i < tags; ++i) {
                DccLocoAddress l = msg.getRailComLocoAddress(i);
                RailCom tag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + l.getNumber());
                tag.setActualSpeed(msg.getRailComSpeed(i));
                this.notify(tag);
            }
            if (tags == 0) {
                this.notify(null);
            }
        }
    }

    @Override
    public void message(Z21Message msg) {
    }

    private void refreshTimer() {
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(15000, e -> this.requestUpdateFromLayout());
        }
        this.refreshTimer.stop();
        this.refreshTimer.setInitialDelay(15000);
        this.refreshTimer.setRepeats(true);
        this.refreshTimer.start();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.refreshTimer.stop();
    }
}

