/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.RailComManager;
import jmri.Reporter;
import jmri.jmrix.roco.z21.Z21CanBusAddress;
import jmri.jmrix.roco.z21.Z21CanReporter;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21Reporter;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21SystemNameComparator;
import jmri.managers.AbstractReporterManager;
import jmri.managers.DefaultRailComManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21ReporterManager
extends AbstractReporterManager
implements Z21Listener {
    private boolean autoCreateInternalReporter = false;
    private static final Logger log = LoggerFactory.getLogger(Z21ReporterManager.class);

    public Z21ReporterManager(Z21SystemConnectionMemo memo) {
        super(memo);
        try {
            InstanceManager.getDefault(RailComManager.class);
        }
        catch (NullPointerException npe) {
            InstanceManager.setDefault(RailComManager.class, new DefaultRailComManager());
        }
        memo.getTrafficController().addz21Listener(this);
        memo.getRocoZ21CommandStation().setRailComMessagesFlag(true);
        memo.getRocoZ21CommandStation().setRailComAutomaticFlag(true);
        memo.getRocoZ21CommandStation().setCanDetectorFlag(true);
        memo.getTrafficController().sendz21Message(Z21Message.getLanSetBroadcastFlagsRequestMessage(memo.getRocoZ21CommandStation().getZ21BroadcastFlags()), null);
        memo.getTrafficController().sendz21Message(Z21Message.getLanRailComGetDataRequestMessage(), this);
    }

    @Override
    @Nonnull
    public Z21SystemConnectionMemo getMemo() {
        return (Z21SystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        if (!systemName.matches(this.getSystemPrefix() + this.typeLetter() + "[1]")) {
            int bitNum = Z21CanBusAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
            if (bitNum != -1) {
                Z21CanReporter r = new Z21CanReporter(systemName, userName, this.getMemo());
                this.register(r);
                return r;
            }
            log.warn("Invalid Reporter name: {} ", (Object)systemName);
            throw new IllegalArgumentException("Invalid Reporter name: " + systemName);
        }
        Z21Reporter r = new Z21Reporter(systemName, userName, this.getMemo());
        this.register(r);
        return r;
    }

    @Override
    public void reply(Z21Reply msg) {
        if (this.autoCreateInternalReporter && msg.isRailComDataChangedMessage()) {
            log.debug("Received RailComDatachanged message");
            String systemName = this.getSystemPrefix() + this.typeLetter() + "1";
            Z21Reporter r = (Z21Reporter)this.getBySystemName(systemName);
            if (null == r) {
                log.debug("Creating reporter {}", (Object)systemName);
                ((Z21Reporter)this.provideReporter(systemName)).reply(msg);
            }
        } else if (msg.isCanDetectorMessage()) {
            int type = msg.getElement(9) & 0xFF;
            log.debug("reporter message type {}", (Object)type);
            if (type >= 17 && type <= 31) {
                log.debug("Received LAN_CAN_DETECTOR message");
                int netID = (msg.getElement(4) & 0xFF) + ((msg.getElement(5) & 0xFF) << 8);
                int msgPort = msg.getElement(8) & 0xFF;
                int address = (msg.getElement(6) & 0xFF) + ((msg.getElement(7) & 0xFF) << 8);
                String systemName = Z21CanBusAddress.buildDecimalSystemNameFromParts(this.getSystemPrefix(), this.typeLetter(), address, msgPort);
                log.debug("asking for reporter {}", (Object)systemName);
                Z21CanReporter r = (Z21CanReporter)this.getBySystemName(systemName);
                if (null == r) {
                    systemName = Z21CanBusAddress.buildHexSystemNameFromParts(this.getSystemPrefix(), this.typeLetter(), netID, msgPort);
                    log.debug("not found; asking for reporter {}", (Object)systemName);
                    r = (Z21CanReporter)this.getBySystemName(systemName);
                    if (null == r) {
                        log.debug("Creating reporter {}", (Object)systemName);
                        ((Z21CanReporter)this.provideReporter(systemName)).reply(msg);
                    }
                }
            }
        }
    }

    @Override
    public void message(Z21Message msg) {
    }

    public void enableInternalReporterCreationFromMessages() {
        this.autoCreateInternalReporter = true;
    }

    @Override
    public Reporter getBySystemName(@Nonnull String sName) {
        Z21SystemNameComparator comparator = new Z21SystemNameComparator(this.getSystemPrefix(), this.typeLetter());
        return (Reporter)this.getBySystemName(sName, comparator);
    }
}

