/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.Comparator;
import java.util.Objects;

public class Z21SystemNameComparator
implements Comparator<String> {
    private String prefix;
    private char typeLetter;

    Z21SystemNameComparator(String prefix, char typeLetter) {
        this.prefix = prefix;
        this.typeLetter = typeLetter;
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.startsWith(this.prefix) && o2.startsWith(this.prefix) && o1.charAt(this.prefix.length()) == this.typeLetter && o2.charAt(this.prefix.length()) == this.typeLetter) {
            if (o1.contains(":")) {
                return this.compareNodePinFormat(o1, o2);
            }
            return o1.substring(this.prefix.length() + 1).compareTo(o2.substring(this.prefix.length() + 1));
        }
        return -1;
    }

    private int compareNodePinFormat(String o1, String o2) {
        int stopIndex;
        int startIndex;
        if (o1.indexOf(58) == o2.indexOf(58) && 0 == o1.substring(startIndex = this.prefix.length() + 1, stopIndex = o1.indexOf(58)).compareToIgnoreCase(o2.substring(startIndex, stopIndex))) {
            return o1.substring(stopIndex).compareToIgnoreCase(o2.substring(stopIndex));
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Z21SystemNameComparator)) {
            return false;
        }
        Z21SystemNameComparator o = (Z21SystemNameComparator)obj;
        return this.prefix.equals(o.prefix) && this.typeLetter == o.typeLetter;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, String.valueOf(this.typeLetter));
    }
}

