/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.roco.z21.Z21Adapter;
import jmri.jmrix.roco.z21.Z21Interface;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21TrafficController
extends AbstractMRTrafficController
implements Z21Interface {
    private InetAddress host;
    private int port;
    private static final Logger log = LoggerFactory.getLogger(Z21TrafficController.class);

    public Z21TrafficController() {
        this.allowUnexpectedReply = true;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((Z21Listener)client).message((Z21Message)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((Z21Listener)client).reply((Z21Reply)m);
    }

    @Override
    protected Z21Message pollMessage() {
        return null;
    }

    @Override
    protected Z21Listener pollReplyHandler() {
        return null;
    }

    @Override
    protected Z21Message enterProgMode() {
        return null;
    }

    @Override
    protected Z21Message enterNormalMode() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"TLW_TWO_LOCK_WAIT", "", "UW_UNCOND_WAIT"}, justification="Two locks needed for synchronization here, this is OK; String + only used for debug, so inefficient String processing not really a problem; Unconditional Wait is to give external hardware, which doesn't necessarilly respond, time to process the data.")
    protected synchronized void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (log.isDebugEnabled()) {
            log.debug("forwardToPort message: [{}]", (Object)m);
        }
        this.mLastSender = reply;
        AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
        SwingUtilities.invokeLater(r);
        byte[] msg = new byte[this.lengthOfByteStream(m)];
        int offset = this.addHeaderToOutput(msg, m);
        int len = m.getNumDataElements();
        for (int i = 0; i < len; ++i) {
            msg[i + offset] = (byte)m.getElement(i);
        }
        this.addTrailerToOutput(msg, len + offset, m);
        try {
            if (log.isDebugEnabled()) {
                StringBuilder f = new StringBuilder("formatted message: ");
                for (byte b : msg) {
                    f.append(Integer.toHexString(0xFF & b));
                    f.append(" ");
                }
                log.debug(new String(f));
            }
            while (m.getRetries() >= 0) {
                if (this.portReadyToSend(this.controller)) {
                    byte[] data = ((Z21Message)m).getBuffer();
                    DatagramPacket sendPacket = new DatagramPacket(data, ((Z21Message)m).getLength(), this.host, this.port);
                    ((Z21Adapter)this.controller).getSocket().send(sendPacket);
                    log.debug("written, msg timeout: {} mSec", (Object)m.getTimeout());
                    break;
                }
                if (m.getRetries() >= 0) {
                    if (log.isDebugEnabled()) {
                        StringBuilder b = new StringBuilder("Retry message: ");
                        b.append(m.toString());
                        b.append(" attempts remaining: ");
                        b.append(m.getRetries());
                        log.debug(new String(b));
                    }
                    m.setRetries(m.getRetries() - 1);
                    try {
                        Runnable b = this.xmtRunnable;
                        synchronized (b) {
                            this.xmtRunnable.wait(m.getTimeout());
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (!this.threadStopRequest) {
                            log.error("retry wait interrupted");
                            continue;
                        }
                        log.error("retry wait interrupted during thread stop");
                        continue;
                    }
                }
                log.warn("sendMessage: port not ready for data sending: {}", (Object)Arrays.toString(msg));
            }
        }
        catch (Exception e) {
            this.xmtException = true;
            this.portWarn(e);
        }
    }

    @Override
    public boolean status() {
        if (this.controller == null) {
            return false;
        }
        return this.controller.status();
    }

    @Override
    public void connectPort(AbstractPortController p) {
        this.rcvException = false;
        this.xmtException = false;
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        } else {
            log.debug("connectPort invoked");
        }
        if (!(p instanceof Z21Adapter)) {
            throw new IllegalArgumentException("attempt to connect wrong port type");
        }
        this.controller = p;
        try {
            this.host = InetAddress.getByName(((Z21Adapter)this.controller).getHostName());
            this.port = ((Z21Adapter)this.controller).getPort();
            ConnectionStatus.instance().setConnectionState(p.getSystemConnectionMemo().getUserName(), ((Z21Adapter)p).getHostName() + ":" + ((Z21Adapter)p).getPort(), "Connected");
        }
        catch (UnknownHostException uhe) {
            log.error("Unknown Host: {} ", (Object)((Z21Adapter)this.controller).getHostName());
            if (((Z21Adapter)p).getPort() != 0) {
                ConnectionStatus.instance().setConnectionState(p.getSystemConnectionMemo().getUserName(), ((Z21Adapter)this.controller).getHostName() + ":" + ((Z21Adapter)p).getPort(), "Not Connected");
            }
            ConnectionStatus.instance().setConnectionState(p.getSystemConnectionMemo().getUserName(), ((Z21Adapter)this.controller).getHostName(), "Not Connected");
        }
        this.xmtRunnable = () -> {
            block2: {
                try {
                    this.transmitLoop();
                }
                catch (Throwable e) {
                    if (this.threadStopRequest) break block2;
                    log.error("Transmit thread terminated prematurely by: {}", (Object)e.toString(), (Object)e);
                }
            }
        };
        this.xmtThread = new Thread(this.xmtRunnable);
        this.xmtThread.setName("z21.Z21TrafficController Transmit thread");
        this.xmtThread.start();
        this.rcvThread = new Thread(this::receiveLoop);
        this.rcvThread.setName("z21.Z21TrafficController Receive thread");
        int xr = this.rcvThread.getPriority();
        this.rcvThread.setPriority(++xr);
        this.rcvThread.start();
    }

    @Override
    public void disconnectPort(AbstractPortController p) {
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected AbstractPortController");
        }
        this.controller = null;
    }

    @Override
    protected Z21Reply newReply() {
        return new Z21Reply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply r) {
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP", "NO_NOTIFY_NOT_NOTIFYALL"}, justification="Wait is for external hardware, which doesn't necessarilly respond, to process the data.  Notify is used because Having more than one thread waiting on xmtRunnable is an error.")
    public void handleOneIncomingReply() throws IOException {
        byte[] buffer = new byte[100];
        DatagramPacket receivePacket = new DatagramPacket(buffer, 100, this.host, this.port);
        try {
            ((Z21Adapter)this.controller).getSocket().receive(receivePacket);
        }
        catch (NullPointerException | SocketException se) {
            log.debug("Socket exception during receive.  Connection Closed?");
            this.rcvException = true;
            return;
        }
        if (this.threadStopRequest) {
            return;
        }
        ArrayList<Z21Reply> replies = new ArrayList<Z21Reply>();
        int totalLength = receivePacket.getLength();
        int consumed = 0;
        do {
            int length = (0xFF & buffer[0]) + ((0xFF & buffer[1]) << 8);
            Z21Reply msg = new Z21Reply(buffer, length);
            replies.add(msg);
            buffer = Arrays.copyOfRange(buffer, length, buffer.length);
            log.trace("total length: {} consumed {}", (Object)totalLength, (Object)(consumed += length));
        } while (totalLength > consumed);
        replies.forEach(this::dispatchReply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void dispatchReply(Z21Reply msg) {
        block37: {
            block36: {
                this.replyInDispatch = true;
                if (Z21TrafficController.log.isDebugEnabled()) {
                    Z21TrafficController.log.debug("dispatch reply of length {} contains {} state {}", new Object[]{msg.getNumDataElements(), msg.toString(), this.mCurrentState});
                }
                r = new AbstractMRTrafficController.RcvNotifier(msg, this.mLastSender, this);
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException ie) {
                    if (this.threadStopRequest) {
                        return;
                    }
                    Z21TrafficController.log.error("Unexpected exception in invokeAndWait:{}", (Object)ie, (Object)ie);
                }
                catch (Exception e) {
                    Z21TrafficController.log.error("Unexpected exception in invokeAndWait:{}", (Object)e, (Object)e);
                }
                if (Z21TrafficController.log.isDebugEnabled()) {
                    Z21TrafficController.log.debug("dispatch thread invoked");
                }
                if (msg.isUnsolicited()) break block36;
                switch (this.mCurrentState) {
                    case 25: {
                        if (msg.isRetransmittableErrorMsg()) {
                            if (Z21TrafficController.log.isDebugEnabled()) {
                                Z21TrafficController.log.debug("Automatic Recovery from Error Message: +msg.toString()");
                            }
                            e = this.xmtRunnable;
                            synchronized (e) {
                                this.mCurrentState = 45;
                                this.replyInDispatch = false;
                                this.xmtRunnable.notify();
                                break;
                            }
                        }
                        e = this.xmtRunnable;
                        synchronized (e) {
                            this.mCurrentState = 15;
                            this.replyInDispatch = false;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 30: {
                        this.mCurrentMode = 4;
                        this.replyInDispatch = false;
                        warmUpDelay = this.enterProgModeDelayTime();
                        if (warmUpDelay == 0) ** GOTO lbl58
                        try {
                            var4_8 = this.xmtRunnable;
                            synchronized (var4_8) {
                                this.xmtRunnable.wait(warmUpDelay);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            if (!this.threadStopRequest) ** GOTO lbl58
                            return;
                        }
lbl58:
                        // 3 sources

                        var4_8 = this.xmtRunnable;
                        synchronized (var4_8) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 35: {
                        this.mCurrentMode = 1;
                        this.replyInDispatch = false;
                        var3_5 = this.xmtRunnable;
                        synchronized (var3_5) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    default: {
                        this.replyInDispatch = false;
                        if (this.allowUnexpectedReply) {
                            if (Z21TrafficController.log.isDebugEnabled()) {
                                Z21TrafficController.log.debug("Allowed unexpected reply received in state: {} was {}", (Object)this.mCurrentState, (Object)msg.toString());
                            }
                            var3_5 = this.xmtRunnable;
                            synchronized (var3_5) {
                                this.xmtRunnable.notify();
                                break;
                            }
                        }
                        this.unexpectedReplyStateError(this.mCurrentState, msg.toString());
                        break;
                    }
                }
                break block37;
            }
            if (Z21TrafficController.log.isDebugEnabled()) {
                Z21TrafficController.log.debug("Unsolicited Message Received {}", (Object)msg.toString());
            }
            this.replyInDispatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"}, justification="Wait is for external hardware, which doesn't necessarilly respond, to process the data.")
    protected void terminate() {
        block9: {
            if (this.controller == null) {
                log.debug("terminate called while not connected");
                return;
            }
            log.debug("Cleanup Starts");
            Z21Message logoffMessage = Z21Message.getLanLogoffRequestMessage();
            this.forwardToPort(logoffMessage, null);
            try {
                if (this.xmtRunnable == null) break block9;
                Runnable runnable = this.xmtRunnable;
                synchronized (runnable) {
                    this.xmtRunnable.wait(logoffMessage.getTimeout());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("transmit interrupted");
            }
            finally {
                this.controller = null;
            }
        }
    }

    @Override
    public void terminateThreads() {
        this.threadStopRequest = true;
        if (this.controller != null && ((Z21Adapter)this.controller).getSocket() != null) {
            ((Z21Adapter)this.controller).getSocket().close();
        }
        super.terminateThreads();
    }

    @Override
    public synchronized void addz21Listener(Z21Listener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removez21Listener(Z21Listener l) {
        this.removeListener(l);
    }

    @Override
    public void sendz21Message(Z21Message m, Z21Listener reply) {
        this.sendMessage(m, reply);
    }
}

