/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.SpeedStepMode;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21XNetReply;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetMessage
extends XNetMessage {
    private static final List<XPressNetMessageFormatter> formatterList = new ArrayList<XPressNetMessageFormatter>();
    private static final Logger log = LoggerFactory.getLogger(Z21XNetMessage.class);

    public Z21XNetMessage(int len) {
        super(len);
    }

    public Z21XNetMessage(Z21Message m) {
        super(m.getLength() - 4);
        for (int i = 4; i < m.getLength(); ++i) {
            this.setElement(i - 4, m.getElement(i));
        }
    }

    public Z21XNetMessage(Z21XNetMessage message) {
        super(message);
    }

    public Z21XNetMessage(Z21XNetReply message) {
        super(message);
    }

    public Z21XNetMessage(String s) {
        super(s);
    }

    @Override
    public String toMonitorString() {
        if (formatterList.isEmpty()) {
            try {
                Reflections reflections = new Reflections("jmri.jmrix", new Scanner[0]);
                Set f2 = reflections.getSubTypesOf(XPressNetMessageFormatter.class);
                for (Class c : f2) {
                    log.debug("Found formatter: {}", (Object)f2.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    formatterList.add((XPressNetMessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
        return formatterList.stream().filter(f -> f.handlesMessage(this)).findFirst().map(f -> f.formatMessage(this)).orElse(this.toString());
    }

    public static Z21XNetMessage getZ21ReadDirectCVMsg(int cv) {
        Z21XNetMessage m = new Z21XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        m.setElement(1, 17);
        m.setElement(2, (0xFF00 & cv - 1) >> 8);
        m.setElement(3, 0xFF & cv - 1);
        m.setParity();
        return m;
    }

    public static Z21XNetMessage getZ21WriteDirectCVMsg(int cv, int val) {
        Z21XNetMessage m = new Z21XNetMessage(6);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 36);
        m.setElement(1, 18);
        m.setElement(2, (0xFF00 & cv - 1) >> 8);
        m.setElement(3, 0xFF & cv - 1);
        m.setElement(4, val);
        m.setParity();
        return m;
    }

    public static Z21XNetMessage getZ21LocomotiveInfoRequestMsg(int address) {
        Z21XNetMessage msg = new Z21XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 240);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static Z21XNetMessage getZ21LocomotiveFunctionOperationMsg(int address, int functionno, boolean state) {
        Z21XNetMessage msg = new Z21XNetMessage(6);
        int functionbyte = functionno;
        msg.setElement(0, 228);
        msg.setElement(1, 248);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        if (state) {
            functionbyte &= 0x3F;
            functionbyte |= 0x40;
        } else {
            functionbyte &= 0x3F;
        }
        msg.setElement(4, functionbyte);
        msg.setParity();
        msg.setBroadcastReply();
        return msg;
    }

    public static XNetMessage getZ21LanXSetLocoDriveMsg(int address, SpeedStepMode speedMode, float speed, boolean isForward) {
        XNetMessage msg = XNetMessage.getSpeedAndDirectionMsg(address, speedMode, speed, isForward);
        msg.setBroadcastReply();
        return msg;
    }

    public static Z21XNetMessage getZ21TurnoutInfoRequestMessage(int address) {
        Z21XNetMessage msg = new Z21XNetMessage(4);
        msg.setElement(0, 67);
        msg.setElement(1, (address - 1 & 0xFF00) >> 8);
        msg.setElement(2, address - 1 & 0xFF);
        msg.setParity();
        return msg;
    }

    public static Z21XNetMessage getZ21SetTurnoutRequestMessage(int address, boolean thrown, boolean active, boolean queue) {
        Z21XNetMessage msg = new Z21XNetMessage(5);
        msg.setElement(0, 83);
        msg.setElement(1, (address - 1 & 0xFF00) >> 8);
        msg.setElement(2, address - 1 & 0xFF);
        int element3 = 128;
        if (active) {
            element3 |= 8;
        }
        if (thrown) {
            element3 |= 1;
        }
        if (queue) {
            element3 |= 0x20;
        }
        msg.setElement(3, element3);
        msg.setParity();
        msg.setBroadcastReply();
        return msg;
    }
}

