/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.ProgListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetOpsModeProgrammer;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetOpsModeProgrammer
extends XNetOpsModeProgrammer
implements LocoNetListener {
    private int _cv;
    private LnTrafficController lnTC;
    public static int operationDelay = 50;
    private static final Logger log = LoggerFactory.getLogger(Z21XNetOpsModeProgrammer.class);

    public Z21XNetOpsModeProgrammer(int pAddress, XNetTrafficController controller) {
        this(pAddress, controller, null);
    }

    public Z21XNetOpsModeProgrammer(int pAddress, XNetTrafficController controller, LnTrafficController lntc) {
        super(pAddress, controller);
        controller.addXNetListener(-1, this);
        this.lnTC = lntc;
        if (this.lnTC != null) {
            this.lnTC.addLocoNetListener(-1, this);
        }
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) {
        int CV = Integer.parseInt(CVname);
        XNetMessage msg = XNetMessage.getWriteOpsModeCVMsg(this.mAddressHigh, this.mAddressLow, CV, val);
        msg.setBroadcastReply();
        this.tc.sendXNetMessage(msg, this);
        this.progListener = p;
        this._cv = 0xFFFF & CV;
        this.value = val;
        this.progState = 1;
        this.restartTimer(msg.getTimeout());
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) {
        int CV = Integer.parseInt(CVname);
        XNetMessage msg = XNetMessage.getVerifyOpsModeCVMsg(this.mAddressHigh, this.mAddressLow, CV, this.value);
        this.progListener = p;
        this._cv = 0xFFFF & CV;
        this.tc.sendXNetMessage(msg, this);
        this.progState = 1;
        this.restartTimer(msg.getTimeout());
    }

    @Override
    public synchronized void confirmCV(String CVname, int val, ProgListener p) {
        int CV = Integer.parseInt(CVname);
        XNetMessage msg = XNetMessage.getVerifyOpsModeCVMsg(this.mAddressHigh, this.mAddressLow, CV, val);
        this.tc.sendXNetMessage(msg, this);
        this.progListener = p;
        this._cv = 0xFFFF & CV;
        this.progState = 1;
        this.restartTimer(msg.getTimeout());
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (this.progState != 0 && this.progState == 1) {
            if (l.isOkMessage()) {
                this.stopTimer();
                ThreadingUtil.runOnLayoutDelayed(() -> {
                    this.progState = 0;
                    this.notifyProgListenerEnd(this.progListener, this.value, 0);
                }, operationDelay);
            } else if (l.getElement(0) == 100 && l.getElement(1) == 20) {
                int sent_cv = (l.getElement(2) << 8) + l.getElement(3) + 1;
                if (sent_cv != this._cv) {
                    return;
                }
                this.value = l.getElement(4);
                this.stopTimer();
                ThreadingUtil.runOnLayoutDelayed(() -> {
                    this.progState = 0;
                    this.notifyProgListenerEnd(this.progListener, this.value, 0);
                }, operationDelay);
            } else if (!l.isRetransmittableErrorMsg()) {
                if (l.getElement(0) == 97 && l.getElement(1) == 19) {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this.progListener, this.value, 2);
                } else if (l.getElement(0) == 97 && l.getElement(1) == 130) {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this.progListener, this.value, 8);
                } else {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this.progListener, this.value, 1);
                }
            }
        }
    }

    @Override
    public synchronized void message(LocoNetMessage m) {
        log.debug("LocoNet message received: {}", (Object)m);
        int slot = m.getElement(2);
        if (slot == 124 && this.progState == 1) {
            log.debug("Right message slot and programming");
            int hopsa = m.getElement(5);
            int lopsa = m.getElement(6);
            int cvh = m.getElement(8);
            int cvl = m.getElement(9);
            int data7 = m.getElement(10);
            int cvNumber = ((cvh & 0x30) >> 3 | cvh & 1) * 128 + (cvl & 0x7F) + 1;
            int address = hopsa * 128 + lopsa;
            if (address != this.mAddress || cvNumber != this._cv) {
                log.debug("message for address {} expecting {}; cv {} expecting {}", new Object[]{address, this.mAddress, cvNumber, this._cv});
                return;
            }
            int val = (m.getElement(2) & 0x20) != 0 ? (cvh & 2) << 6 | data7 & 0x7F : -1;
            log.debug("received value {} for cv {} on address {}", new Object[]{val, cvNumber, address});
            int code = m.getElement(2) == 127 ? 1 : 0;
            this.progState = 0;
            this.stopTimer();
            log.debug("delay to sending code {} val {} to programmer", (Object)code, (Object)val);
            ThreadingUtil.runOnLayoutDelayed(() -> {
                this.progState = 0;
                log.debug("now ending code {} val {} to programmer", (Object)code, (Object)val);
                this.notifyProgListenerEnd(this.progListener, val, code);
            }, operationDelay);
        }
    }
}

