/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.roco.z21.Z21XNetMessage;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetReply
extends XNetReply {
    private static final List<XPressNetMessageFormatter> formatterList = new ArrayList<XPressNetMessageFormatter>();
    private static final Logger log = LoggerFactory.getLogger(Z21XNetReply.class);

    public Z21XNetReply() {
    }

    public Z21XNetReply(Z21XNetReply reply) {
        super(reply);
    }

    public Z21XNetReply(Z21XNetMessage message) {
        super(message);
    }

    public Z21XNetReply(String message) {
        super(message);
    }

    @Override
    public boolean isServiceModeResponse() {
        return this.getElement(0) == 100 && this.getElement(1) == 20 || super.isServiceModeResponse();
    }

    @Override
    public boolean isFeedbackMessage() {
        return this.getElement(0) == 67 || super.isFeedbackMessage();
    }

    @Override
    public String toMonitorString() {
        if (formatterList.isEmpty()) {
            try {
                Reflections reflections = new Reflections("jmri.jmrix", new Scanner[0]);
                Set f2 = reflections.getSubTypesOf(XPressNetMessageFormatter.class);
                for (Class c : f2) {
                    log.debug("Found formatter: {}", (Object)f2.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    formatterList.add((XPressNetMessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
        return formatterList.stream().filter(f -> f.handlesMessage(this)).findFirst().map(f -> f.formatMessage(this)).orElse(this.toString());
    }
}

