/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetStreamPortController;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21XNetMessage;
import jmri.jmrix.roco.z21.Z21XNetReply;
import jmri.jmrix.roco.z21.Z21XNetStreamPortController;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XPressNetTunnel
implements Z21Listener,
XNetListener,
Runnable {
    XNetStreamPortController xsc = null;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private Z21SystemConnectionMemo _memo;
    private final Thread sourceThread;
    private volatile boolean stopThread = false;
    private static final Logger log = LoggerFactory.getLogger(Z21XPressNetTunnel.class);

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"}, justification="done at end, waits for data")
    public Z21XPressNetTunnel(Z21SystemConnectionMemo memo) {
        this._memo = memo;
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
            this.sourceThread = null;
            return;
        }
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("z21.Z21XpressNetTunnel sourceThread");
        this.sourceThread.setDaemon(true);
        this.sourceThread.start();
        this.setStreamPortController(new Z21XNetStreamPortController(this.pin, this.pout, "None"));
        this._memo.getTrafficController().addz21Listener(this);
        this.xsc.configure();
    }

    @Override
    public void run() {
        log.debug("Simulator Thread Started");
        while (!this.stopThread) {
            Z21XNetMessage m = this.readMessage();
            if (m == null) continue;
            this.message(m);
        }
    }

    private Z21XNetMessage readMessage() {
        Z21XNetMessage msg = null;
        try {
            msg = this.loadChars();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msg;
    }

    private Z21XNetMessage loadChars() throws IOException {
        byte char1 = this.readByteProtected(this.inpipe);
        int len = (char1 & 0xF) + 2;
        if ((char1 & 0xFF) == 67) {
            len = 4;
        }
        Z21XNetMessage msg = new Z21XNetMessage(len);
        msg.setElement(0, char1 & 0xFF);
        for (int i = 1; i < len; ++i) {
            char1 = this.readByteProtected(this.inpipe);
            msg.setElement(i, char1 & 0xFF);
        }
        return msg;
    }

    private byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        byte[] rcvBuffer = new byte[1];
        while ((nchars = istream.read(rcvBuffer, 0, 1)) <= 0) {
        }
        return rcvBuffer[0];
    }

    @Override
    public void reply(Z21Reply msg) {
        if (msg.isXPressNetTunnelMessage()) {
            Z21XNetReply reply = msg.getXNetReply();
            log.debug("Z21 Reply {} forwarded to XpressNet implementation as {}", (Object)msg, (Object)reply);
            for (int i = 0; i < reply.getNumDataElements(); ++i) {
                try {
                    this.outpipe.writeByte(reply.getElement(i));
                    continue;
                }
                catch (IOException ioe) {
                    log.error("Error writing XpressNet Reply to XpressNet input stream.");
                }
            }
        }
    }

    @Override
    public void message(Z21Message msg) {
    }

    @Override
    public void message(XNetReply msg) {
    }

    @Override
    public void message(XNetMessage msg) {
        Z21Message message = new Z21Message(msg);
        log.debug("XpressNet Message {} forwarded to z21 Interface as {}", (Object)msg, (Object)message);
        this._memo.getTrafficController().sendz21Message(message, this);
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
    }

    XNetStreamPortController getStreamPortController() {
        return this.xsc;
    }

    void setStreamPortController(XNetStreamPortController x) {
        this.xsc = x;
        this.xsc.getSystemConnectionMemo().setSystemPrefix("X");
        this.xsc.getSystemConnectionMemo().setUserName(this._memo.getUserName() + "XpressNet");
    }

    public void dispose() {
        if (this.xsc != null) {
            this.xsc.dispose();
        }
        try {
            this.inpipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.sourceThread != null) {
            this.stopThread = true;
            this.sourceThread.interrupt();
            try {
                this.sourceThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

