/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.messageformatters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.Message;
import jmri.jmrix.roco.z21.Z21MessageFormatter;
import jmri.jmrix.roco.z21.Z21MessageUtils;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.messageformatters.Bundle;

public class Z21CANDetectorReplyFormatter
implements Z21MessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof Z21Reply && ((Z21Reply)m).getOpCode() == 196;
    }

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public String formatMessage(Message m) {
        Object value1String;
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("Message is not a Z21 CAN Detector Reply");
        }
        int networkID = (m.getElement(4) & 0xFF) + ((m.getElement(5) & 0xFF) << 8);
        int address = (m.getElement(6) & 0xFF) + ((m.getElement(7) & 0xFF) << 8);
        int port = m.getElement(8) & 0xFF;
        int type = m.getElement(9) & 0xFF;
        int value1 = (m.getElement(10) & 0xFF) + ((m.getElement(11) & 0xFF) << 8);
        int value2 = (m.getElement(12) & 0xFF) + ((m.getElement(13) & 0xFF) << 8);
        String typeString = "";
        Object value2String = "";
        block0 : switch (type) {
            case 1: {
                typeString = "Input Status";
                switch (value1) {
                    case 0: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_FREE_WITHOUT");
                        break block0;
                    }
                    case 256: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_FREE_WITH");
                        break block0;
                    }
                    case 4096: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_BUSY_WITHOUT");
                        break block0;
                    }
                    case 4352: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_BUSY_WITH");
                        break block0;
                    }
                    case 4609: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_OVERLOAD_1");
                        break block0;
                    }
                    case 4610: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_OVERLOAD_2");
                        break block0;
                    }
                    case 4611: {
                        value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_OVERLOAD_3");
                        break block0;
                    }
                }
                value1String = "<unknown>";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                typeString = "Occupancy Info";
                value1String = this.getCanDetectorLocoAddressString(value1);
                value2String = this.getCanDetectorLocoAddressString(value2);
                break;
            }
            default: {
                value1String = "" + value1;
                value2String = "" + value2;
            }
        }
        return Bundle.getMessage("Z21CANDetectorReply", Integer.toHexString(networkID), address, port, typeString, value1String, value2String);
    }

    private String getCanDetectorLocoAddressString(int addressValue) {
        Object addressString;
        if (addressValue == 0) {
            addressString = "end of list";
        } else {
            addressString = Z21MessageUtils.getCanDetectorLocoAddress(addressValue).toString();
            int direction = 0xC000 & addressValue;
            switch (direction) {
                case 32768: {
                    addressString = (String)addressString + " direction forward";
                    break;
                }
                case 49152: {
                    addressString = (String)addressString + " direction reverse";
                    break;
                }
                default: {
                    addressString = (String)addressString + " direction unknown";
                }
            }
        }
        return addressString;
    }
}

