/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.messageformatters;

import jmri.jmrix.Message;
import jmri.jmrix.roco.z21.Z21MessageFormatter;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.messageformatters.Bundle;

public class Z21FastClockDataReplyFormatter
implements Z21MessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof Z21Reply && ((Z21Reply)m).getOpCode() == 205;
    }

    @Override
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("Message is not supported");
        }
        int day = (m.getElement(6) & 0xE0) >> 5;
        int hour = m.getElement(6) & 0x1F;
        int minute = m.getElement(7) & 0x3F;
        int second = m.getElement(8) & 0x3F;
        boolean stopped = (m.getElement(8) & 0x10000000) != 0;
        boolean paused = (m.getElement(8) & 0x1000000) != 0;
        int rate = m.getElement(9) & 0x3F;
        int settings = m.getElement(10);
        return Bundle.getMessage("Z21ClockMessageString", day, hour, minute, second, rate, stopped ? Bundle.getMessage("ClockStopped") : "", paused ? Bundle.getMessage("ClockPaused") : "", this.formatSettings(settings));
    }

    String formatSettings(int settings) {
        StringBuilder sb = new StringBuilder();
        sb.append("settings ");
        if ((settings & 1) == 1) {
            sb.append(Bundle.getMessage("LocoNetClock"));
        }
        if ((settings & 2) == 2) {
            sb.append(Bundle.getMessage("XPressNetBroadcast"));
        }
        if ((settings & 8) == 8) {
            sb.append(Bundle.getMessage("DCCBroadcast"));
        }
        if ((settings & 0x10) == 16) {
            sb.append(Bundle.getMessage("MRClockMulticast"));
        }
        if ((settings & 0x40) == 64) {
            sb.append(Bundle.getMessage("ClockEStop"));
        }
        if ((settings & 0x80) == 128) {
            sb.append(Bundle.getMessage("ClockEnabled"));
        }
        return sb.toString();
    }
}

