/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.messageformatters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.Message;
import jmri.jmrix.roco.z21.Z21MessageFormatter;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.messageformatters.Bundle;

public class Z21HardwareInfoReplyFormatter
implements Z21MessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof Z21Reply && ((Z21Reply)m).getOpCode() == 26;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="cast is checked in handlesMessage")
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("Z21HardwareInfoReplyFormatter cannot format message that it does not handle");
        }
        Z21Reply r = (Z21Reply)m;
        int hwversion = r.getElement(4) + (r.getElement(5) << 8) + (r.getElement(6) << 16) + (r.getElement(7) << 24);
        float swversion = (float)r.getElementBCD(8).intValue() / 100.0f + (float)r.getElementBCD(9).intValue() + (float)(r.getElementBCD(10) * 100) + (float)(r.getElementBCD(11) * 10000);
        return Bundle.getMessage("Z21ReplyStringVersion", Integer.toHexString(hwversion), Float.valueOf(swversion));
    }
}

