/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.messageformatters;

import jmri.jmrix.Message;
import jmri.jmrix.lenz.XPressNetMessageFormatter;
import jmri.jmrix.lenz.messageformatters.XNetLocoInfoReplyUtilities;
import jmri.jmrix.roco.z21.Z21XNetReply;

public class Z21XNetLocoReplyFormatter
implements XPressNetMessageFormatter {
    @Override
    public boolean handlesMessage(Message m) {
        return m instanceof Z21XNetReply && (m.getElement(0) & 0xE0) == 224 && (m.getElement(0) & 0xF) >= 7 && (m.getElement(0) & 0xF) <= 15;
    }

    @Override
    public String formatMessage(Message m) {
        if (!this.handlesMessage(m)) {
            throw new IllegalArgumentException("Message is not a Z21XNetReply");
        }
        int messageaddress = ((m.getElement(1) & 0x3F) << 8) + (m.getElement(2) & 0xFF);
        String text = "Z21 Mobile decoder info reply for address " + messageaddress + ":";
        int b2 = m.getElement(3) & 0xFF;
        int b3 = m.getElement(4) & 0xFF;
        int b4 = m.getElement(5) & 0xFF;
        int b5 = m.getElement(6) & 0xFF;
        int b6 = m.getElement(7) & 0xFF;
        int b7 = m.getElement(8) & 0xFF;
        text = text + " " + XNetLocoInfoReplyUtilities.parseSpeedAndDirection(b2, b3);
        text = text + " " + XNetLocoInfoReplyUtilities.parseFunctionStatus(b4, b5);
        text = text + " " + XNetLocoInfoReplyUtilities.parseFunctionHighStatus(b6, b7);
        return text;
    }
}

