/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.simulator;

import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.roco.z21.simulator.Z21SimulatorLocoData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetSimulatorAdapter {
    private int csStatus = 0;
    private static final int csEmergencyStop = 1;
    private static final int csNormalMode = 0;
    Z21SimulatorLocoData[] locoData = new Z21SimulatorLocoData[20];
    int locoCount;
    int locoPosition;
    private static final Logger log = LoggerFactory.getLogger(Z21XNetSimulatorAdapter.class);

    XNetReply generateReply(XNetMessage m) {
        XNetReply reply;
        log.debug("Generating Reply");
        block0 : switch (m.getElement(0) & 0xFF) {
            case 33: {
                log.debug("CS Request Received");
                switch (m.getElement(1)) {
                    case 33: {
                        reply = this.xNetVersionReply();
                        break block0;
                    }
                    case 129: {
                        this.csStatus = 0;
                        reply = this.normalOpsReply();
                        break block0;
                    }
                    case 128: {
                        this.csStatus = 1;
                        reply = this.everythingOffReply();
                        break block0;
                    }
                    case 36: {
                        reply = this.csStatusReply();
                        break block0;
                    }
                }
                log.debug("Unsupported requested received: {}", (Object)m.toString());
                reply = this.notSupportedReply();
                break;
            }
            case 240: {
                log.debug("LI Version Request Received");
                reply = new XNetReply();
                reply.setOpCode(2);
                reply.setElement(1, 0);
                reply.setElement(2, 0);
                reply.setElement(3, 0);
                reply.setParity();
                break;
            }
            case 228: {
                log.debug("Locomotive Operations Request received");
                switch (m.getElement(1) & 0xFF) {
                    case 16: {
                        reply = new XNetReply();
                        reply.setOpCode(239);
                        reply.setElement(1, m.getElement(2));
                        reply.setElement(2, m.getElement(3));
                        reply.setElement(3, 0);
                        reply.setElement(4, m.getElement(4) & 0xFF);
                        reply.setElement(5, 0);
                        reply.setElement(6, 0);
                        reply.setElement(7, 0);
                        reply.setElement(8, 0);
                        reply.setElement(9, 0);
                        reply.setElement(10, 0);
                        reply.setElement(11, 0);
                        reply.setElement(12, 0);
                        reply.setElement(13, 0);
                        reply.setElement(14, 0);
                        reply.setElement(15, 0);
                        reply.setElement(16, 0);
                        reply.setParity();
                        this.locoData[this.locoPosition] = new Z21SimulatorLocoData((byte)(m.getElement(2) & 0xFF), (byte)(m.getElement(3) & 0xFF), (byte)(m.getElement(4) & 0xFF));
                        this.locoCount = (this.locoCount + 1) % 19;
                        if (this.locoCount < 19) {
                            ++this.locoCount;
                        }
                        this.locoPosition = (this.locoPosition + 1) % 19;
                        break block0;
                    }
                    case 18: {
                        reply = new XNetReply();
                        reply.setOpCode(239);
                        reply.setElement(1, m.getElement(2));
                        reply.setElement(2, m.getElement(3));
                        reply.setElement(3, 2);
                        reply.setElement(4, m.getElement(4));
                        reply.setElement(5, 0);
                        reply.setElement(6, 0);
                        reply.setElement(7, 0);
                        reply.setElement(8, 0);
                        reply.setElement(9, 0);
                        reply.setElement(10, 0);
                        reply.setElement(11, 0);
                        reply.setElement(12, 0);
                        reply.setElement(13, 0);
                        reply.setElement(14, 0);
                        reply.setElement(15, 0);
                        reply.setElement(16, 0);
                        reply.setParity();
                        this.locoData[this.locoPosition] = new Z21SimulatorLocoData((byte)(m.getElement(2) & 0xFF), (byte)(m.getElement(3) & 0xFF), (byte)(m.getElement(4) & 0xFF));
                        if (this.locoCount < 19) {
                            ++this.locoCount;
                        }
                        this.locoPosition = (this.locoPosition + 1) % 19;
                        break block0;
                    }
                    case 19: {
                        reply = new XNetReply();
                        reply.setOpCode(239);
                        reply.setElement(1, m.getElement(2));
                        reply.setElement(2, m.getElement(3));
                        reply.setElement(3, 4);
                        reply.setElement(4, m.getElement(4));
                        reply.setElement(5, 0);
                        reply.setElement(6, 0);
                        reply.setElement(7, 0);
                        reply.setElement(8, 0);
                        reply.setElement(9, 0);
                        reply.setElement(10, 0);
                        reply.setElement(11, 0);
                        reply.setElement(12, 0);
                        reply.setElement(13, 0);
                        reply.setElement(14, 0);
                        reply.setElement(15, 0);
                        reply.setElement(16, 0);
                        reply.setParity();
                        reply.setParity();
                        this.locoData[this.locoPosition] = new Z21SimulatorLocoData((byte)(m.getElement(2) & 0xFF), (byte)(m.getElement(3) & 0xFF), (byte)(m.getElement(4) & 0xFF));
                        if (this.locoCount < 19) {
                            ++this.locoCount;
                        }
                        this.locoPosition = (this.locoPosition + 1) % 19;
                        break block0;
                    }
                    case 248: {
                        reply = new XNetReply();
                        reply.setOpCode(239);
                        reply.setElement(1, m.getElement(2));
                        reply.setElement(2, m.getElement(3));
                        reply.setElement(3, 4);
                        reply.setElement(4, 0);
                        reply.setElement(5, 0);
                        reply.setElement(6, 0);
                        reply.setElement(7, 0);
                        reply.setElement(8, 0);
                        reply.setElement(9, 0);
                        reply.setElement(10, 0);
                        reply.setElement(11, 0);
                        reply.setElement(12, 0);
                        reply.setElement(13, 0);
                        reply.setElement(14, 0);
                        reply.setElement(15, 0);
                        reply.setElement(16, 0);
                        reply.setParity();
                        break block0;
                    }
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 44: {
                        reply = this.okReply();
                        break block0;
                    }
                }
                log.debug("Unsupported requested received: {}", (Object)m.toString());
                reply = this.notSupportedReply();
                break;
            }
            case 128: {
                log.debug("Emergency Stop Received");
                reply = this.emergencyStopReply();
                break;
            }
            case 145: 
            case 146: {
                reply = this.okReply();
                break;
            }
            case 82: {
                log.debug("Accessory Operations Request received");
                reply = this.okReply();
                break;
            }
            case 227: {
                log.debug("Locomotive Status Request received");
                switch (m.getElement(1) & 0xFF) {
                    case 0: {
                        reply = new XNetReply();
                        reply.setOpCode(228);
                        reply.setElement(1, 4);
                        reply.setElement(2, 0);
                        reply.setElement(3, 0);
                        reply.setElement(4, 0);
                        reply.setElement(5, 0);
                        reply.setParity();
                        break block0;
                    }
                    case 240: {
                        reply = new XNetReply();
                        reply.setOpCode(239);
                        reply.setElement(1, m.getElement(2));
                        reply.setElement(2, m.getElement(3));
                        reply.setElement(3, 4);
                        reply.setElement(4, 0);
                        reply.setElement(5, 0);
                        reply.setElement(6, 0);
                        reply.setElement(7, 0);
                        reply.setElement(8, 0);
                        reply.setElement(9, 0);
                        reply.setElement(10, 0);
                        reply.setElement(11, 0);
                        reply.setElement(12, 0);
                        reply.setElement(13, 0);
                        reply.setElement(14, 0);
                        reply.setElement(15, 0);
                        reply.setElement(16, 0);
                        reply.setParity();
                        break block0;
                    }
                }
                log.debug("Unsupoorted requested received: {}", (Object)m.toString());
                reply = this.notSupportedReply();
                break;
            }
            case 66: {
                log.debug("Accessory Information Request Received");
                reply = new XNetReply();
                reply.setOpCode(66);
                reply.setElement(1, m.getElement(1));
                if (m.getElement(1) < 64) {
                    if (m.getElement(2) == 128) {
                        reply.setElement(2, 0);
                    } else {
                        reply.setElement(2, 16);
                    }
                } else if (m.getElement(2) == 128) {
                    reply.setElement(2, 64);
                } else {
                    reply.setElement(2, 80);
                }
                reply.setElement(3, 0);
                reply.setParity();
                break;
            }
            case 67: {
                log.debug("Get Turnout Info Request Received");
                reply = this.lanXTurnoutInfoReply(m.getElement(1), m.getElement(2), true);
                break;
            }
            case 83: {
                log.debug("Set Turnout Request Received");
                reply = this.lanXTurnoutInfoReply(m.getElement(1), m.getElement(2), (1 & m.getElement(3)) == 1);
                break;
            }
            case 230: {
                if (m.getElement(1) == 48) {
                    int operation = m.getElement(4) & 0xFC;
                    switch (operation) {
                        case 236: {
                            log.debug("Write CV in Ops Mode Request Received");
                            reply = this.okReply();
                            break block0;
                        }
                        case 228: {
                            log.debug("Verify CV in Ops Mode Request Received");
                            reply = new XNetReply();
                            reply.setOpCode(100);
                            reply.setElement(1, 20);
                            reply.setElement(2, m.getElement(4) & 3);
                            reply.setElement(3, m.getElement(5));
                            reply.setElement(4, m.getElement(6));
                            reply.setElement(5, 0);
                            reply.setParity();
                            break block0;
                        }
                        case 232: {
                            log.debug("Ops Mode Bit Request Received");
                            reply = this.okReply();
                            break block0;
                        }
                    }
                    reply = this.notSupportedReply();
                    break;
                }
                reply = this.notSupportedReply();
                break;
            }
            default: {
                log.debug("Unsupported requested received: {}", (Object)m.toString());
                reply = this.notSupportedReply();
            }
        }
        log.debug("generated reply {}", (Object)reply);
        return reply;
    }

    private XNetReply notSupportedReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(97);
        r.setElement(1, 130);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply okReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(1);
        r.setElement(1, 4);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply normalOpsReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(97);
        r.setElement(1, 1);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply everythingOffReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(97);
        r.setElement(1, 0);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply emergencyStopReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(129);
        r.setElement(1, 0);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply xNetVersionReply() {
        XNetReply reply = new XNetReply();
        reply.setOpCode(99);
        reply.setElement(1, 33);
        reply.setElement(2, 48);
        reply.setElement(3, 18);
        reply.setElement(4, 0);
        reply.setParity();
        return reply;
    }

    private XNetReply csStatusReply() {
        XNetReply reply = new XNetReply();
        reply.setOpCode(98);
        reply.setElement(1, 34);
        reply.setElement(2, this.csStatus);
        reply.setElement(3, 0);
        reply.setParity();
        return reply;
    }

    private XNetReply lanXTurnoutInfoReply(int FAdr_MSB, int FAdr_LSB, boolean thrown) {
        XNetReply reply = new XNetReply();
        reply.setOpCode(67);
        reply.setElement(1, FAdr_MSB & 0xFF);
        reply.setElement(2, FAdr_LSB & 0xFF);
        reply.setElement(3, thrown ? 2 : 1);
        reply.setElement(4, 0);
        reply.setParity();
        return reply;
    }
}

