/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.swing.mon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.Message;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21MessageFormatter;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.swing.mon.Bundle;
import jmri.util.swing.JmriNamedPaneAction;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21MonPane
extends AbstractMonPane
implements Z21Listener {
    protected Z21SystemConnectionMemo memo = null;
    private List<Z21MessageFormatter> formatterList;
    private static final Logger log = LoggerFactory.getLogger(Z21MonPane.class);

    @Override
    public String getTitle() {
        return Bundle.getMessage("Z21TrafficTitle");
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof Z21SystemConnectionMemo) {
            this.memo = (Z21SystemConnectionMemo)context;
            this.memo.getTrafficController().addz21Listener(this);
            try {
                this.formatterList = new ArrayList<Z21MessageFormatter>();
                Reflections reflections = new Reflections("jmri.jmrix.roco.z21", new Scanner[0]);
                Set f = reflections.getSubTypesOf(Z21MessageFormatter.class);
                for (Class c : f) {
                    log.debug("Found formatter: {}", (Object)f.getClass().getName());
                    Constructor ctor = c.getConstructor(new Class[0]);
                    this.formatterList.add((Z21MessageFormatter)ctor.newInstance(new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error instantiating formatter", (Throwable)e);
            }
        }
    }

    @Override
    protected void init() {
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removez21Listener(this);
        super.dispose();
    }

    @Override
    public void logMessage(String messagePrefix, String rawPrefix, Message message) {
        StringBuilder raw = new StringBuilder(rawPrefix);
        if (this.rawCheckBox.isSelected()) {
            raw.append(message.toString());
        }
        String text = this.formatterList.stream().filter(f -> f.handlesMessage(message)).findFirst().map(f -> f.formatMessage(message)).orElse(message.toString());
        this.nextLine(messagePrefix + " " + text + "\n", raw.toString());
    }

    @Override
    public synchronized void reply(Z21Reply l) {
        this.logMessage(l);
    }

    @Override
    public synchronized void message(Z21Message l) {
        this.logMessage(l);
    }

    public static class Default
    extends JmriNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("Z21TrafficTitle"), Z21MonPane.class.getName());
            this.setContext(InstanceManager.getDefault(Z21SystemConnectionMemo.class));
        }
    }
}

