/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import javax.vecmath.Point3d;
import jmri.jmrix.rps.Calculator;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCalculator
implements Calculator {
    Point3d[] sensors;
    double[] Tr;
    double[] Xr;
    double[] Yr;
    double[] Zr;
    int nr;
    private static final Logger log = LoggerFactory.getLogger(AbstractCalculator.class);

    public void prep(Reading r) {
        if (log.isDebugEnabled()) {
            log.debug("Reading: {}", (Object)r.toString());
            log.debug("Sensors: {}", (Object)this.sensors.length);
            if (this.sensors.length >= 1 && this.sensors[0] != null) {
                log.debug("Sensor[0]: {},{},{}", new Object[]{this.sensors[0].x, this.sensors[0].y, this.sensors[0].z});
            }
            if (this.sensors.length >= 2 && this.sensors[1] != null) {
                log.debug("Sensor[1]: {},{},{}", new Object[]{this.sensors[1].x, this.sensors[1].y, this.sensors[1].z});
            }
        }
        this.nr = r.getNValues();
        if (this.nr != this.sensors.length - 1) {
            log.error("Mismatch: {} readings, {} receivers", (Object)this.nr, (Object)(this.sensors.length - 1));
        }
        this.nr = Math.min(this.nr, this.sensors.length - 1);
        this.Tr = new double[this.nr];
        this.Xr = new double[this.nr];
        this.Yr = new double[this.nr];
        this.Zr = new double[this.nr];
        int j = 0;
        for (int i = 0; i <= this.nr; ++i) {
            if (this.sensors[i] == null) continue;
            this.Tr[j] = r.getValue(i);
            this.Xr[j] = this.sensors[i].x;
            this.Yr[j] = this.sensors[i].y;
            this.Zr[j] = this.sensors[i].z;
            ++j;
        }
        this.nr = j;
        this.summarize();
    }

    void summarize() {
        log.debug("nr is {}", (Object)this.nr);
        for (int j = 0; j < this.nr; ++j) {
            log.debug(" t: {} to {},{},{}", new Object[]{this.Tr[j], this.Xr[j], this.Yr[j], this.Zr[j]});
        }
    }
}

