/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.AbstractCalculator;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analytic_AAlgorithm
extends AbstractCalculator {
    double Vs;
    double Xt = 0.0;
    double Yt = 0.0;
    double Zt = 0.0;
    int offset = 0;
    private static final Logger log = LoggerFactory.getLogger(Analytic_AAlgorithm.class);

    public Analytic_AAlgorithm(Point3d[] sensors, double vsound, int offset) {
        this(sensors, vsound);
        this.offset = offset;
    }

    public Analytic_AAlgorithm(Point3d[] sensors, double vsound) {
        this.sensors = Arrays.copyOf(sensors, sensors.length);
        this.Vs = vsound;
    }

    public Analytic_AAlgorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3}, vsound);
    }

    public Analytic_AAlgorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, Point3d sensor4, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3, sensor4}, vsound);
    }

    @Override
    public Measurement convert(Reading r) {
        if (log.isDebugEnabled()) {
            log.debug("Reading: {}", (Object)r.toString());
            log.debug("Sensors: {}", (Object)this.sensors.length);
            if (this.sensors.length >= 1 && this.sensors[0] != null) {
                log.debug("Sensor[0]: {},{},{}", new Object[]{this.sensors[0].x, this.sensors[0].y, this.sensors[0].z});
            }
        }
        log.debug("There should have been an earth-shattering kaboom!");
        double[][] Xs = new double[33][3];
        boolean[] SV = new boolean[33];
        for (int i = 0; i < 33; ++i) {
            SV[i] = false;
        }
        double[] P = new double[33];
        double[] Xr = new double[3];
        Xr[2] = 0.0;
        Xr[1] = 0.0;
        Xr[0] = 0.0;
        this.nr = r.getNValues();
        if (this.nr != this.sensors.length - 1) {
            log.error("Mismatch: {} readings, {} receivers", (Object)this.nr, (Object)(this.sensors.length - 1));
        }
        this.nr = Math.min(this.nr, this.sensors.length - 1);
        int j = 0;
        for (int i = 0; i <= this.nr; ++i) {
            if (this.sensors[i] == null) continue;
            P[j] = r.getValue(i) * this.Vs;
            Xs[j][0] = this.sensors[i].x;
            Xs[j][1] = this.sensors[i].y;
            Xs[j][2] = this.sensors[i].z;
            SV[j] = true;
            log.debug("  {}th point at {},{},{} time={} is distance {}", new Object[]{j, Xs[j][0], Xs[j][1], Xs[j][2], r.getValue(i), P[j]});
            ++j;
        }
        this.nr = j;
        log.debug("nr is {}", (Object)this.nr);
        double[] result = this.solve(Xs, SV, P, Xr);
        if (result == null) {
            log.error("failed to converge");
            return new Measurement(r, -99999.0, -99999.0, -99999.0, this.Vs, -20, "Analytic_A");
        }
        this.Xt = result[0];
        this.Yt = result[1];
        this.Zt = result[2];
        log.debug("Result x = {} y = {} z0 = {} time offset={}", new Object[]{this.Xt, this.Yt, this.Zt, result[3]});
        return new Measurement(r, this.Xt, this.Yt, this.Zt, this.Vs, this.nr, "Analytic_A");
    }

    @Override
    public Measurement convert(Reading r, Point3d guess) {
        this.Xt = guess.x;
        this.Yt = guess.y;
        this.Zt = guess.z;
        return this.convert(r);
    }

    @Override
    public Measurement convert(Reading r, Measurement last) {
        if (last != null) {
            this.Xt = last.getX();
            this.Yt = last.getY();
            this.Zt = last.getZ();
        }
        if (this.Xt > 9.0E99) {
            this.Xt = 0.0;
        }
        if (this.Yt > 9.0E99) {
            this.Yt = 0.0;
        }
        if (this.Zt > 9.0E99) {
            this.Zt = 0.0;
        }
        return this.convert(r);
    }

    public double[] solve(double[][] Xs, boolean[] SV, double[] P, double[] Xr) {
        double[] R = new double[33];
        double[] L = new double[33];
        double[][] A = new double[33][4];
        double[] AL2 = new double[4];
        double[][] AA = new double[4][4];
        double[][] AAi = new double[4][4];
        double[] D = new double[5];
        int it = 0;
        do {
            int i;
            int k;
            int k2;
            ++it;
            for (int prn = 1; prn <= 32; ++prn) {
                if (!SV[prn]) continue;
                R[prn] = Math.sqrt((Xr[0] - Xs[prn][0]) * (Xr[0] - Xs[prn][0]) + (Xr[1] - Xs[prn][1]) * (Xr[1] - Xs[prn][1]) + (Xr[2] - Xs[prn][2]) * (Xr[2] - Xs[prn][2]));
                L[prn] = P[prn] - R[prn];
                for (int k3 = 0; k3 < 3; ++k3) {
                    A[prn][k3] = (Xr[k3] - Xs[prn][k3]) / R[prn];
                }
                A[prn][3] = -1.0;
            }
            for (k2 = 0; k2 <= 3; ++k2) {
                AL2[k2] = 0.0;
                for (int prn = 1; prn <= 32; ++prn) {
                    if (!SV[prn]) continue;
                    int n = k2;
                    AL2[n] = AL2[n] + A[prn][k2] * L[prn];
                }
            }
            for (k2 = 0; k2 <= 3; ++k2) {
                for (int i2 = 0; i2 <= 3; ++i2) {
                    AA[k2][i2] = 0.0;
                    for (int prn = 1; prn <= 32; ++prn) {
                        if (!SV[prn]) continue;
                        double[] dArray = AA[k2];
                        int n = i2;
                        dArray[n] = dArray[n] + A[prn][k2] * A[prn][i2];
                    }
                }
            }
            double det = AA[0][0] * this.sub(AA, 0, 0) - AA[1][0] * this.sub(AA, 1, 0) + AA[2][0] * this.sub(AA, 2, 0) - AA[3][0] * this.sub(AA, 3, 0);
            if (det == 0.0) {
                return null;
            }
            for (k = 0; k <= 3; ++k) {
                for (i = 0; i <= 3; ++i) {
                    int n = k + i;
                    int j = n % 2 != 0 ? -1 : 1;
                    AAi[k][i] = (double)j * this.sub(AA, i, k) / det;
                }
            }
            for (k = 0; k <= 3; ++k) {
                D[k] = 0.0;
                for (i = 0; i <= 3; ++i) {
                    int n = k;
                    D[n] = D[n] + AAi[k][i] * AL2[i];
                }
            }
            for (k = 0; k < 3; ++k) {
                int n = k;
                Xr[n] = Xr[n] + D[k];
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("  after {}, delta is {}", (Object)it, (Object)(Math.abs(D[0]) + Math.abs(D[1]) + Math.abs(D[2])));
        } while (it < 6 && Math.abs(D[0]) + Math.abs(D[1]) + Math.abs(D[2]) >= 0.01);
        double Cr = D[3];
        if (it >= 6) {
            log.error("Can't solve, iteration limit exceeded.  it = {}", (Object)it);
            return null;
        }
        return new double[]{Xr[0], Xr[1], Xr[2], Cr};
    }

    public double sub(double[][] A, int r, int c) {
        double[][] B = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            int i1 = i;
            if (i >= r) {
                ++i1;
            }
            for (int j = 0; j < 3; ++j) {
                int j1 = j;
                if (j >= c) {
                    ++j1;
                }
                B[i][j] = A[i1][j1];
            }
        }
        double subdet = B[0][0] * (B[1][1] * B[2][2] - B[1][2] * B[2][1]) - B[1][0] * (B[0][1] * B[2][2] - B[2][1] * B[0][2]) + B[2][0] * (B[0][1] * B[1][2] - B[0][2] * B[1][1]);
        return subdet;
    }

    static class RetVal {
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int code;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        double x;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        double y;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        double z;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        double vs;

        RetVal(int code, double x, double y, double z, double vs) {
            this.code = code;
            this.x = x;
            this.y = y;
            this.z = z;
            this.vs = vs;
        }
    }
}

