/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.Calculator;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ash1_1Algorithm
implements Calculator {
    double Vs;
    double Xt = 0.0;
    double Yt = 0.0;
    double Zt = 0.0;
    Point3d[] sensors;
    static final int OFFSET = 0;
    static final int TMAX = 35000;
    static final int TMIN = 150;
    static final int NMAX = 15;
    double x;
    double y;
    double z;
    double x0;
    double y0;
    double z0;
    double Rmax;
    double xi;
    double yi;
    double zi;
    double ri;
    double xj;
    double yj;
    double zj;
    double rj;
    double xk;
    double yk;
    double zk;
    double rk;
    private static final Logger log = LoggerFactory.getLogger(Ash1_1Algorithm.class);

    public Ash1_1Algorithm(Point3d[] sensors, double vsound) {
        this.sensors = Arrays.copyOf(sensors, sensors.length);
        this.Vs = vsound;
    }

    public Ash1_1Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3}, vsound);
    }

    public Ash1_1Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, Point3d sensor4, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3, sensor4}, vsound);
    }

    @Override
    public Measurement convert(Reading r) {
        int nr = r.getNValues();
        if (nr != this.sensors.length) {
            log.error("Mismatch: {} readings, {} receivers", (Object)nr, (Object)this.sensors.length);
        }
        nr = Math.min(nr, this.sensors.length);
        double[] Tr = new double[nr];
        double[] Xr = new double[nr];
        double[] Yr = new double[nr];
        double[] Zr = new double[nr];
        for (int i = 0; i < nr; ++i) {
            Tr[i] = r.getValue(i);
            Xr[i] = this.sensors[i].x;
            Yr[i] = this.sensors[i].y;
            Zr[i] = this.sensors[i].z;
        }
        RetVal result = this.RPSpos(nr, Tr, Xr, Yr, Zr, this.Vs, this.Xt, this.Yt, this.Zt);
        this.Xt = result.x;
        this.Yt = result.y;
        this.Zt = result.z;
        this.Vs = result.vs;
        log.debug("x = {} y = {} z0 = {} code = {}", new Object[]{this.Xt, this.Yt, this.Zt, result.code});
        return new Measurement(r, this.Xt, this.Yt, this.Zt, this.Vs, result.code, "Ash1_1Algorithm");
    }

    @Override
    public Measurement convert(Reading r, Point3d guess) {
        this.Xt = guess.x;
        this.Yt = guess.y;
        this.Zt = guess.z;
        return this.convert(r);
    }

    @Override
    public Measurement convert(Reading r, Measurement last) {
        if (last != null) {
            this.Xt = last.getX();
            this.Yt = last.getY();
            this.Zt = last.getZ();
        }
        if (this.Xt > 9.0E99) {
            this.Xt = 0.0;
        }
        if (this.Yt > 9.0E99) {
            this.Yt = 0.0;
        }
        if (this.Zt > 9.0E99) {
            this.Zt = 0.0;
        }
        return this.convert(r);
    }

    @SuppressFBWarnings(value={"IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN"})
    RetVal RPSpos(int nr, double[] Tr, double[] Xr, double[] Yr, double[] Zr, double Vs, double Xt, double Yt, double Zt) {
        double w;
        int j;
        int i;
        double[] Rs = new double[15];
        double[] Xs = new double[15];
        double[] Ys = new double[15];
        double[] Zs = new double[15];
        int k = 0;
        int ns = 0;
        Rs[14] = 35000.0;
        this.Rmax = Vs * 35000.0;
        block0: for (i = 0; i < nr; ++i) {
            double Rq;
            if (Tr[i] == 0.0 || (Rq = Vs * (Tr[i] + 0.0)) >= this.Rmax || Rq < Vs * 150.0) continue;
            if (ns == 0) {
                Rs[0] = Rq;
                Xs[0] = Xr[i];
                Ys[0] = Yr[i];
                Zs[0] = Zr[i];
                ns = 1;
                continue;
            }
            int n = j = ns == 15 ? ns - 1 : ns++;
            while (true) {
                if (j <= 0 || !(Rq < Rs[j - 1])) {
                    if (j >= 14 && !(Rq < Rs[j])) continue block0;
                    Rs[j] = Rq;
                    Xs[j] = Xr[i];
                    Ys[j] = Yr[i];
                    Zs[j] = Zr[i];
                    continue block0;
                }
                Rs[j] = Rs[j - 1];
                Xs[j] = Xs[j - 1];
                Ys[j] = Ys[j - 1];
                Zs[j] = Zs[j - 1];
                --j;
            }
        }
        if (ns < 3) {
            Zt = 9.9999999E99;
            Yt = 9.9999999E99;
            Xt = 9.9999999E99;
            return new RetVal(1, Xt, Yt, Zt, Vs);
        }
        this.y = 0.0;
        this.x = 0.0;
        this.z = -100000.0;
        for (i = 0; i < 1000; ++i) {
            if (i < ns) {
                j = i;
            } else {
                while ((j = (int)Math.floor((double)ns * Math.random())) == k) {
                }
            }
            k = j;
            w = Math.sqrt((Xs[j] - this.x) * (Xs[j] - this.x) + (Ys[j] - this.y) * (Ys[j] - this.y) + (Zs[j] - this.z) * (Zs[j] - this.z));
            w = Rs[j] / w;
            this.x = w * (this.x - Xs[j]) + Xs[j];
            this.y = w * (this.y - Ys[j]) + Ys[j];
            this.z = w * (this.z - Zs[j]) + Zs[j];
        }
        double Zw = 0.0;
        double Yw = 0.0;
        double Xw = 0.0;
        double Ww = 0.0;
        for (i = 0; i < ns - 2; ++i) {
            this.xi = Xs[i];
            this.yi = Ys[i];
            this.zi = Zs[i];
            this.ri = Rs[i];
            for (j = i + 1; j < ns - 1; ++j) {
                this.xj = Xs[j];
                this.yj = Ys[j];
                this.zj = Zs[j];
                this.rj = Rs[j];
                for (k = j + 1; k < ns; ++k) {
                    double d;
                    this.xk = Xs[k];
                    this.yk = Ys[k];
                    this.zk = Zs[k];
                    this.rk = Rs[k];
                    if (this.gps3() != 0) continue;
                    w = this.wgt();
                    if (!(d > 0.0)) continue;
                    Ww += w;
                    Xw += w * this.x0;
                    Yw += w * this.y0;
                    Zw += w * this.z0;
                }
            }
        }
        if (Ww > 0.0) {
            Xt = Xw / Ww;
            Yt = Yw / Ww;
            Zt = Zw / Ww;
            return new RetVal(0, Xt, Yt, Zt, Vs);
        }
        Zt = 9.9999999E99;
        Yt = 9.9999999E99;
        Xt = 9.9999999E99;
        return new RetVal(2, Xt, Yt, Zt, Vs);
    }

    double wgt() {
        double w = (1.0 - this.ri / this.Rmax) * (1.0 - this.rj / this.Rmax) * (1.0 - this.rk / this.Rmax);
        w *= 1.0 - Math.pow(((this.x - this.xi) * (this.x - this.xj) + (this.y - this.yi) * (this.y - this.yj) + (this.z - this.zi) * (this.z - this.zj)) / this.ri / this.rj, 2.0);
        w *= 1.0 - Math.pow(((this.x - this.xi) * (this.x - this.xk) + (this.y - this.yi) * (this.y - this.yk) + (this.z - this.zi) * (this.z - this.zk)) / this.ri / this.rk, 2.0);
        w *= 1.0 - Math.pow(((this.x - this.xj) * (this.x - this.xk) + (this.y - this.yj) * (this.y - this.yk) + (this.z - this.zj) * (this.z - this.zk)) / this.rj / this.rk, 2.0);
        w *= 0.05 + Math.abs((this.zi + this.zj + this.zk - 3.0 * this.z) / (this.ri + this.rj + this.rk));
        w *= (((this.yk - this.yi) * (this.zj - this.zi) - (this.yj - this.yi) * (this.zk - this.zi)) * (this.x - this.xi) + ((this.zk - this.zi) * (this.xj - this.xi) - (this.zj - this.zi) * (this.xk - this.xi)) * (this.y - this.yi) + ((this.xk - this.xi) * (this.yj - this.yi) - (this.xj - this.xi) * (this.yk - this.yi)) * (this.z - this.zi)) / (this.ri * this.rj * this.rk);
        if ((w = Math.abs(w)) > 0.5 || w < 5.0E-7) {
            w = 0.0;
        }
        return w;
    }

    int gps3() {
        double z2;
        double y2;
        double x2;
        double z1;
        double y1;
        double x1;
        double xik = this.xi - this.xk;
        double yik = this.yi - this.yk;
        double zik = this.zi - this.zk;
        double xjk = this.xj - this.xk;
        double yjk = this.yj - this.yk;
        double zjk = this.zj - this.zk;
        double Ci = (this.xi * this.xi - this.xk * this.xk + this.yi * this.yi - this.yk * this.yk + this.zi * this.zi - this.zk * this.zk - this.ri * this.ri + this.rk * this.rk) / 2.0;
        double Cj = (this.xj * this.xj - this.xk * this.xk + this.yj * this.yj - this.yk * this.yk + this.zj * this.zj - this.zk * this.zk - this.rj * this.rj + this.rk * this.rk) / 2.0;
        double Dz = xik * yjk - xjk * yik;
        double Dy = zik * xjk - zjk * xik;
        double Dx = yik * zjk - yjk * zik;
        if (Math.abs(Dx) > Math.abs(Dy) && Math.abs(Dx) > Math.abs(Dz)) {
            double Ay = (zik * xjk - zjk * xik) / Dx;
            double By = (zjk * Ci - zik * Cj) / Dx;
            double Az = (yjk * xik - yik * xjk) / Dx;
            double Bz = (yik * Cj - yjk * Ci) / Dx;
            double Ax = Ay * Ay + Az * Az + 1.0;
            double Bx = (Ay * (this.yk - By) + Az * (this.zk - Bz) + this.xk) / Ax;
            double Cx = Bx * Bx - (By * By + Bz * Bz - 2.0 * this.yk * By - 2.0 * this.zk * Bz + this.yk * this.yk + this.zk * this.zk + this.xk * this.xk - this.rk * this.rk) / Ax;
            if (Cx < 0.0) {
                this.z0 = 9.9999999E99;
                this.y0 = 9.9999999E99;
                this.x0 = 9.9999999E99;
                return 1;
            }
            x1 = Bx + Math.sqrt(Cx);
            y1 = Ay * x1 + By;
            z1 = Az * x1 + Bz;
            x2 = 2.0 * Bx - x1;
            y2 = Ay * x2 + By;
            z2 = Az * x2 + Bz;
        } else if (Math.abs(Dy) > Math.abs(Dz)) {
            double Az = (xik * yjk - xjk * yik) / Dy;
            double Bz = (xjk * Ci - xik * Cj) / Dy;
            double Ax = (zjk * yik - zik * yjk) / Dy;
            double Bx = (zik * Cj - zjk * Ci) / Dy;
            double Ay = Az * Az + Ax * Ax + 1.0;
            double By = (Az * (this.zk - Bz) + Ax * (this.xk - Bx) + this.yk) / Ay;
            double Cy = By * By - (Bz * Bz + Bx * Bx - 2.0 * this.zk * Bz - 2.0 * this.xk * Bx + this.zk * this.zk + this.xk * this.xk + this.yk * this.yk - this.rk * this.rk) / Ay;
            if (Cy < 0.0) {
                this.z0 = 9.9999999E99;
                this.y0 = 9.9999999E99;
                this.x0 = 9.9999999E99;
                return 1;
            }
            y1 = By + Math.sqrt(Cy);
            z1 = Az * y1 + Bz;
            x1 = Ax * y1 + Bx;
            y2 = 2.0 * By - y1;
            z2 = Az * y2 + Bz;
            x2 = Ax * y2 + Bx;
        } else {
            if (Dz == 0.0) {
                this.z0 = 9.9999999E99;
                this.y0 = 9.9999999E99;
                this.x0 = 9.9999999E99;
                return 1;
            }
            double Ax = (yik * zjk - yjk * zik) / Dz;
            double Bx = (yjk * Ci - yik * Cj) / Dz;
            double Ay = (xjk * zik - xik * zjk) / Dz;
            double By = (xik * Cj - xjk * Ci) / Dz;
            double Az = Ax * Ax + Ay * Ay + 1.0;
            double Bz = (Ax * (this.xk - Bx) + Ay * (this.yk - By) + this.zk) / Az;
            double Cz = Bz * Bz - (Bx * Bx + By * By - 2.0 * this.xk * Bx - 2.0 * this.yk * By + this.xk * this.xk + this.yk * this.yk + this.zk * this.zk - this.rk * this.rk) / Az;
            if (Cz < 0.0) {
                this.z0 = 9.9999999E99;
                this.y0 = 9.9999999E99;
                this.x0 = 9.9999999E99;
                return 1;
            }
            z1 = Bz + Math.sqrt(Cz);
            x1 = Ax * z1 + Bx;
            y1 = Ay * z1 + By;
            z2 = 2.0 * Bz - z1;
            x2 = Ax * z2 + Bx;
            y2 = Ay * z2 + By;
        }
        double e1 = (this.x - x1) * (this.x - x1) + (this.y - y1) * (this.y - y1) + (this.z - z1) * (this.z - z1);
        double e2 = (this.x - x2) * (this.x - x2) + (this.y - y2) * (this.y - y2) + (this.z - z2) * (this.z - z2);
        if (e1 <= e2) {
            this.x0 = x1;
            this.y0 = y1;
            this.z0 = z1;
        } else {
            this.x0 = x2;
            this.y0 = y2;
            this.z0 = z2;
        }
        return 0;
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    static class RetVal {
        int code;
        double x;
        double y;
        double z;
        double t;
        double vs;

        RetVal(int code, double x, double y, double z, double vs) {
            this.code = code;
            this.x = x;
            this.y = y;
            this.z = z;
            this.vs = vs;
        }
    }
}

