/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.AbstractCalculator;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ash2_0Algorithm
extends AbstractCalculator {
    double Vs;
    double Xt = 0.0;
    double Yt = 0.0;
    double Zt = 0.0;
    int offset = 0;
    static final int TMAX = 35000;
    static final int TMIN = 150;
    static final int SMAX = 30;
    static final int NMAX = 50;
    private static final Logger log = LoggerFactory.getLogger(Ash2_0Algorithm.class);

    public Ash2_0Algorithm(Point3d[] sensors, double vsound, int offset) {
        this(sensors, vsound);
        this.offset = offset;
    }

    public Ash2_0Algorithm(Point3d[] sensors, double vsound) {
        this.sensors = Arrays.copyOf(sensors, sensors.length);
        this.Vs = vsound;
    }

    public Ash2_0Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3}, vsound);
    }

    public Ash2_0Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, Point3d sensor4, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3, sensor4}, vsound);
    }

    @Override
    public Measurement convert(Reading r) {
        int code;
        this.prep(r);
        RetVal result = this.RPSpos(this.nr, this.Tr, this.Xr, this.Yr, this.Zr, this.Vs, this.Xt, this.Yt, this.Zt);
        this.Xt = result.x;
        this.Yt = result.y;
        this.Zt = result.z;
        this.Vs = result.vs;
        switch (result.code) {
            case 0: {
                code = 4;
                break;
            }
            case 1: {
                code = 0;
                break;
            }
            case 2: {
                code = -this.Tr.length;
                break;
            }
            default: {
                log.error("Unexpected error code: {}", (Object)result.code);
                code = 0;
            }
        }
        log.debug("old code={} new code={}", (Object)result.code, (Object)code);
        log.debug("x = {} y = {} z0 = {} code = {}", new Object[]{this.Xt, this.Yt, this.Zt, code});
        return new Measurement(r, this.Xt, this.Yt, this.Zt, this.Vs, code, "Ash2_0Algorithm");
    }

    @Override
    public Measurement convert(Reading r, Point3d guess) {
        this.Xt = guess.x;
        this.Yt = guess.y;
        this.Zt = guess.z;
        return this.convert(r);
    }

    @Override
    public Measurement convert(Reading r, Measurement last) {
        if (last != null) {
            this.Xt = last.getX();
            this.Yt = last.getY();
            this.Zt = last.getZ();
        }
        if (this.Xt > 9.0E99) {
            this.Xt = 0.0;
        }
        if (this.Yt > 9.0E99) {
            this.Yt = 0.0;
        }
        if (this.Zt > 9.0E99) {
            this.Zt = 0.0;
        }
        return this.convert(r);
    }

    @SuppressFBWarnings(value={"IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN"})
    RetVal RPSpos(int nr, double[] Tr, double[] Xr, double[] Yr, double[] Zr, double Vs, double Xt, double Yt, double Zt) {
        double w;
        double q;
        int i;
        int[] ce = new int[50];
        double[] Rs = new double[50];
        double[] Xs = new double[50];
        double[] Ys = new double[50];
        double[] Zs = new double[50];
        int k = 0;
        int j = 0;
        double var = 0.0;
        double vmax = 900.0 * Vs * Vs;
        double vmin = 1.0 * Vs * Vs;
        int ns = 0;
        Rs[49] = 35000.0;
        double Rmax = Vs * 35000.0;
        block0: for (i = 0; i < nr; ++i) {
            double Rq;
            if (Tr[i] == 0.0 || (Rq = Vs * (Tr[i] + (double)this.offset)) >= Rmax || Rq < Vs * 150.0) continue;
            if (ns == 0) {
                Rs[0] = Rq;
                Xs[0] = Xr[i];
                Ys[0] = Yr[i];
                Zs[0] = Zr[i];
                ns = 1;
                continue;
            }
            int n = j = ns == 50 ? ns - 1 : ns++;
            while (true) {
                if (j <= 0 || !(Rq < Rs[j - 1])) {
                    if (j >= 49 && !(Rq < Rs[j])) continue block0;
                    Rs[j] = Rq;
                    Xs[j] = Xr[i];
                    Ys[j] = Yr[i];
                    Zs[j] = Zr[i];
                    continue block0;
                }
                Rs[j] = Rs[j - 1];
                Xs[j] = Xs[j - 1];
                Ys[j] = Ys[j - 1];
                Zs[j] = Zs[j - 1];
                --j;
            }
        }
        for (i = 0; i < ns; ++i) {
            ce[i] = 0;
        }
        for (i = 0; i < ns - 1; ++i) {
            for (j = i + 1; j < ns; ++j) {
                q = Math.sqrt((Xs[i] - Xs[j]) * (Xs[i] - Xs[j]) + (Ys[i] - Ys[j]) * (Ys[i] - Ys[j]) + (Zs[i] - Zs[j]) * (Zs[i] - Zs[j]));
                if (!(Rs[i] + Rs[j] < q) && !(Rs[i] - Rs[j] > q) && !(Rs[j] - Rs[i] > q)) continue;
                int n = i;
                ce[n] = ce[n] + 1;
                int n2 = j;
                ce[n2] = ce[n2] + 1;
            }
        }
        int cmax = 1;
        while (cmax != 0) {
            cmax = 0;
            for (i = 0; i < ns; ++i) {
                if (ce[i] < cmax) continue;
                cmax = ce[i];
                j = i;
            }
            if (cmax <= 0) continue;
            for (i = 0; i < ns; ++i) {
                if (i == j || !(Rs[i] + Rs[j] < (q = Math.sqrt((Xs[i] - Xs[j]) * (Xs[i] - Xs[j]) + (Ys[i] - Ys[j]) * (Ys[i] - Ys[j]) + (Zs[i] - Zs[j]) * (Zs[i] - Zs[j])))) && !(Rs[i] - Rs[j] > q) && !(Rs[j] - Rs[i] > q)) continue;
                int n = i;
                ce[n] = ce[n] - 1;
            }
            for (i = j; i < ns - 1; ++i) {
                Rs[i] = Rs[i + 1];
                Xs[i] = Xs[i + 1];
                Ys[i] = Ys[i + 1];
                Zs[i] = Zs[i + 1];
                ce[i] = ce[i + 1];
            }
            --ns;
        }
        if (ns < 3) {
            Zt = 9.9999999E99;
            Yt = 9.9999999E99;
            Xt = 9.9999999E99;
            return new RetVal(1, Xt, Yt, Zt, Vs);
        }
        double y = 0.0;
        double x = 0.0;
        double z = -100000.0;
        for (i = 0; i < 1250; ++i) {
            if (i < 50) {
                j = k = i % ns;
            } else if (i < 1000) {
                while ((j = (int)Math.floor((double)ns * Math.random())) == k) {
                }
                k = j;
            } else {
                j = (1249 - i) % ns;
            }
            if (i < 750) {
                w = 1.0;
            } else {
                w = 1.0 - Rs[j] / Rmax;
                w *= w;
            }
            if (i >= 1000) {
                w *= 5.0 - 0.004 * (double)i;
            }
            q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
            q = w * (1.0 - Rs[j] / q);
            x += q * (Xs[j] - x);
            y += q * (Ys[j] - y);
            z += q * (Zs[j] - z);
        }
        for (i = 0; i < 15; ++i) {
            var = 0.0;
            double Zw = 0.0;
            double Yw = 0.0;
            double Xw = 0.0;
            double Ww = 0.0;
            for (j = 0; j < ns; ++j) {
                q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
                double err = q - Rs[j];
                q = 1.0 - Rs[j] / q;
                w = 1.0 - Rs[j] / Rmax;
                w *= w;
                Xw += w * (x + q * (Xs[j] - x));
                Yw += w * (y + q * (Ys[j] - y));
                Zw += w * (z + q * (Zs[j] - z));
                Ww += w;
                var += w * err * err;
            }
            x = Xw / Ww;
            y = Yw / Ww;
            z = Zw / Ww;
            var /= Ww;
        }
        Xt = x;
        Yt = y;
        Zt = z;
        if (var > vmax || ns == 3 && var > vmin) {
            return new RetVal(2, Xt, Yt, Zt, Vs);
        }
        return new RetVal(0, Xt, Yt, Zt, Vs);
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    static class RetVal {
        int code;
        double x;
        double y;
        double z;
        double t;
        double vs;

        RetVal(int code, double x, double y, double z, double vs) {
            this.code = code;
            this.x = x;
            this.y = y;
            this.z = z;
            this.vs = vs;
        }
    }
}

