/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.AbstractCalculator;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ash2_1Algorithm
extends AbstractCalculator {
    double Vs;
    double Xt = 0.0;
    double Yt = 0.0;
    double Zt = 0.0;
    int offset = 0;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int TMAX = 35000;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int TMIN = 150;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int SMAX = 30;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int NMAX = 50;
    private static final Logger log = LoggerFactory.getLogger(Ash2_1Algorithm.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public Ash2_1Algorithm(Point3d[] sensors, double vsound, int offset) {
        this(sensors, vsound);
        this.offset = offset;
    }

    public Ash2_1Algorithm(Point3d[] sensors, double vsound) {
        this.sensors = Arrays.copyOf(sensors, sensors.length);
        this.Vs = vsound;
    }

    public Ash2_1Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3}, vsound);
    }

    public Ash2_1Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, Point3d sensor4, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3, sensor4}, vsound);
    }

    @Override
    public Measurement convert(Reading r) {
        if (log.isDebugEnabled()) {
            log.debug("Reading: {}", (Object)r);
            log.debug("Sensors: {}", (Object)this.sensors.length);
            if (this.sensors.length >= 1 && this.sensors[0] != null) {
                log.debug("Sensor[0]: {},{},{}", new Object[]{this.sensors[0].x, this.sensors[0].y, this.sensors[0].z});
            }
            if (this.sensors.length >= 2 && this.sensors[1] != null) {
                log.debug("Sensor[1]: {},{},{}", new Object[]{this.sensors[1].x, this.sensors[1].y, this.sensors[1].z});
            }
        }
        this.prep(r);
        RetVal result = this.RPSpos(this.nr, this.Tr, this.Xr, this.Yr, this.Zr, this.Vs, this.Xt, this.Yt, this.Zt);
        this.Xt = result.x;
        this.Yt = result.y;
        this.Zt = result.z;
        this.Vs = result.vs;
        log.debug("x = {} y = {} z0 = {} code = {}", new Object[]{this.Xt, this.Yt, this.Zt, result.code});
        return new Measurement(r, this.Xt, this.Yt, this.Zt, this.Vs, result.code, "Ash2_1Algorithm");
    }

    @Override
    public Measurement convert(Reading r, Point3d guess) {
        this.Xt = guess.x;
        this.Yt = guess.y;
        this.Zt = guess.z;
        return this.convert(r);
    }

    @Override
    public Measurement convert(Reading r, Measurement last) {
        if (last != null) {
            this.Xt = last.getX();
            this.Yt = last.getY();
            this.Zt = last.getZ();
        }
        if (this.Xt > 9.0E99) {
            this.Xt = 0.0;
        }
        if (this.Yt > 9.0E99) {
            this.Yt = 0.0;
        }
        if (this.Zt > 9.0E99) {
            this.Zt = 0.0;
        }
        return this.convert(r);
    }

    RetVal RPSpos(int nr, double[] Tr, double[] Xr, double[] Yr, double[] Zr, double Vs, double Xt, double Yt, double Zt) {
        double q;
        int i;
        int[] ce = new int[NMAX];
        double[] Rs = new double[NMAX];
        double[] Xs = new double[NMAX];
        double[] Ys = new double[NMAX];
        double[] Zs = new double[NMAX];
        int nox = 0;
        int jmax = 0;
        int k = 0;
        int j = 0;
        double w = 0.0;
        double var = 0.0;
        double vmax = (double)(SMAX * SMAX) * Vs * Vs;
        double vmin = 1.0 * Vs * Vs;
        int ns = 0;
        double Rmax = Vs * (double)TMAX;
        Rs[Ash2_1Algorithm.NMAX - 1] = TMAX;
        block0: for (i = 0; i < nr; ++i) {
            double Rq;
            if (Tr[i] == 0.0 || (Rq = Vs * (Tr[i] + (double)this.offset)) >= Rmax || Rq < Vs * (double)TMIN) continue;
            if (ns == 0) {
                Rs[0] = Rq;
                Xs[0] = Xr[i];
                Ys[0] = Yr[i];
                Zs[0] = Zr[i];
                ns = 1;
                continue;
            }
            int n = j = ns == NMAX ? ns - 1 : ns++;
            while (true) {
                if (j <= 0 || !(Rq < Rs[j - 1])) {
                    if (j >= NMAX - 1 && !(Rq < Rs[j])) continue block0;
                    Rs[j] = Rq;
                    Xs[j] = Xr[i];
                    Ys[j] = Yr[i];
                    Zs[j] = Zr[i];
                    continue block0;
                }
                Rs[j] = Rs[j - 1];
                Xs[j] = Xs[j - 1];
                Ys[j] = Ys[j - 1];
                Zs[j] = Zs[j - 1];
                --j;
            }
        }
        for (i = 0; i < ns; ++i) {
            ce[i] = 0;
        }
        for (i = 0; i < ns - 1; ++i) {
            for (j = i + 1; j < ns; ++j) {
                q = Math.sqrt((Xs[i] - Xs[j]) * (Xs[i] - Xs[j]) + (Ys[i] - Ys[j]) * (Ys[i] - Ys[j]) + (Zs[i] - Zs[j]) * (Zs[i] - Zs[j]));
                if (!(Rs[i] + Rs[j] < q) && !(Rs[i] - Rs[j] > q) && !(Rs[j] - Rs[i] > q)) continue;
                int n = i;
                ce[n] = ce[n] + 1;
                int n2 = j;
                ce[n2] = ce[n2] + 1;
            }
        }
        int cmax = 1;
        int nxx = 0;
        while (cmax != 0) {
            cmax = 0;
            for (i = 0; i < ns; ++i) {
                if (ce[i] < cmax) continue;
                if (ce[i] > 0) {
                    nxx = ce[i] == cmax ? nxx + 1 : 1;
                }
                cmax = ce[i];
                j = i;
            }
            if (cmax <= 0) continue;
            for (i = 0; i < ns; ++i) {
                if (i == j || !(Rs[i] + Rs[j] < (q = Math.sqrt((Xs[i] - Xs[j]) * (Xs[i] - Xs[j]) + (Ys[i] - Ys[j]) * (Ys[i] - Ys[j]) + (Zs[i] - Zs[j]) * (Zs[i] - Zs[j])))) && !(Rs[i] - Rs[j] > q) && !(Rs[j] - Rs[i] > q)) continue;
                int n = i;
                ce[n] = ce[n] - 1;
            }
            for (i = j; i < ns - 1; ++i) {
                Rs[i] = Rs[i + 1];
                Xs[i] = Xs[i + 1];
                Ys[i] = Ys[i + 1];
                Zs[i] = Zs[i + 1];
                ce[i] = ce[i + 1];
            }
            --ns;
        }
        int nss = ns;
        if (ns < 3) {
            Zt = 9.9999999E99;
            Yt = 9.9999999E99;
            Xt = 9.9999999E99;
            return new RetVal(0, Xt, Yt, Zt, Vs);
        }
        int tov = 0;
        i = 0;
        int S = 0;
        double y = 0.0;
        double x = 0.0;
        double z = -100000.0;
        while (S < 4) {
            if (S == 0) {
                j = k = i % ns;
                w = 1.0;
            } else if (S == 1) {
                while ((j = (int)Math.floor((double)ns * Math.random())) == k) {
                }
                k = j;
                w = 1.0;
            } else if (S == 2) {
                j = --k % ns;
                w = 1.0 - Rs[j] / Rmax;
                w *= w;
                w *= 0.01 * (double)(k + 1);
            } else if (S == 3) {
                // empty if block
            }
            if (S < 3) {
                q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
                q = w * (1.0 - Rs[j] / q);
                x += q * (Xs[j] - x);
                y += q * (Ys[j] - y);
                z += q * (Zs[j] - z);
                ++i;
            }
            if (S == 1 && i % 50 == 0 || S == 2 && k == 0 || S == 3) {
                double emax = 0.0;
                double Zw = 0.0;
                double Yw = 0.0;
                double Xw = 0.0;
                double Ww = 0.0;
                double vold = var;
                var = 0.0;
                for (j = 0; j < ns; ++j) {
                    q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
                    double err = q - Rs[j];
                    err *= err;
                    q = 1.0 - Rs[j] / q;
                    if (S >= 2) {
                        w = 1.0 - Rs[j] / Rmax;
                        w *= w;
                    } else {
                        w = 1.0;
                    }
                    Xw += w * (x + q * (Xs[j] - x));
                    Yw += w * (y + q * (Ys[j] - y));
                    Zw += w * (z + q * (Zs[j] - z));
                    Ww += w;
                    var += w * err;
                    if (!(w * err > emax)) continue;
                    emax = w * err;
                    jmax = j;
                }
                x = Xw / Ww;
                y = Yw / Ww;
                z = Zw / Ww;
                var /= Ww;
                i += ns;
                double thr = (10.0 - 30.0 / (double)ns) * Ww / (double)ns;
                if (S >= 2 && ns > 3 && (ns > 4 && emax > var * thr || var > 3.0 * vmax)) {
                    tov = emax > var * thr ? 0 : 1;
                    nox = 0;
                    Rs[jmax] = Rs[--ns];
                    Xs[jmax] = Xs[ns];
                    Ys[jmax] = Ys[ns];
                    Zs[jmax] = Zs[ns];
                } else {
                    ++nox;
                }
                if (S == 1 && (var > 0.999 * vold && var < 3.0 * vmax || var < vmin || i >= 750)) {
                    k = 200;
                    nox = 0;
                    ++S;
                }
                if (S == 2 && k == 0) {
                    k = 200;
                    if (nox >= 2 && var > 0.999 * vold || var < vmin || i >= 2000) {
                        nox = 0;
                        ++S;
                    }
                }
                if (S == 3 && (nox >= 1 + 110 / (ns + 5) && var > 0.999 * vold || var < 0.1 * vmin || i >= 2500 - ns)) {
                    ++S;
                }
            }
            if (S != 0 || i < 50) continue;
            k = j;
            var = 9.0E9;
            ++S;
        }
        Xt = x;
        Yt = y;
        Zt = z;
        if (var > vmax || ns == 3 && var > vmin) {
            return new RetVal(-ns, Xt, Yt, Zt, Vs);
        }
        if (ns == 3 && (nss > 4 || nxx > 1 || tov != 0)) {
            return new RetVal(1, Xt, Yt, Zt, Vs);
        }
        if (ns == 4 && (nss > 5 || nss == 5 && nxx == 1 && tov == 1)) {
            return new RetVal(2, Xt, Yt, Zt, Vs);
        }
        if (ns >= 5 && nss > (3 * ns - 3) / 2) {
            return new RetVal(2, Xt, Yt, Zt, Vs);
        }
        return new RetVal(ns, Xt, Yt, Zt, Vs);
    }

    static class RetVal {
        int code;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double x;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double y;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double z;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double t;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double vs;

        RetVal(int code, double x, double y, double z, double vs) {
            this.code = code;
            this.x = x;
            this.y = y;
            this.z = z;
            this.vs = vs;
        }
    }
}

