/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.util.Vector;
import javax.swing.SwingUtilities;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Distributor {
    private static volatile Distributor instance = null;
    private final Vector<ReadingListener> readingListeners = new Vector();
    private final Vector<MeasurementListener> measurementListeners = new Vector();
    private static final Logger log = LoggerFactory.getLogger(Distributor.class);

    public void addReadingListener(ReadingListener l) {
        if (!this.readingListeners.contains(l)) {
            this.readingListeners.addElement(l);
        }
    }

    public void removeReadingListener(ReadingListener l) {
        if (this.readingListeners.contains(l)) {
            this.readingListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitReading(Reading s) {
        Vector v;
        Distributor distributor = this;
        synchronized (distributor) {
            v = (Vector)this.readingListeners.clone();
        }
        log.debug("notify {} ReadingListeners about item", (Object)v.size());
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            ReadingListener client = (ReadingListener)v.elementAt(i);
            SwingUtilities.invokeLater(new ForwardReading(s, client));
        }
    }

    public void addMeasurementListener(MeasurementListener l) {
        if (!this.measurementListeners.contains(l)) {
            this.measurementListeners.addElement(l);
        }
    }

    public void removeMeasurementListener(MeasurementListener l) {
        if (this.measurementListeners.contains(l)) {
            this.measurementListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitMeasurement(Measurement s) {
        Vector v;
        Distributor distributor = this;
        synchronized (distributor) {
            v = (Vector)this.measurementListeners.clone();
        }
        log.debug("notify {} MeasurementListeners about item", (Object)v.size());
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            MeasurementListener client = (MeasurementListener)v.elementAt(i);
            SwingUtilities.invokeLater(new ForwardMeasurement(s, client));
        }
    }

    public static Distributor instance() {
        if (instance == null) {
            instance = new Distributor();
        }
        return instance;
    }

    static class ForwardMeasurement
    implements Runnable {
        Measurement s;
        MeasurementListener client;

        ForwardMeasurement(Measurement s, MeasurementListener client) {
            this.s = s;
            this.client = client;
        }

        @Override
        public void run() {
            this.client.notify(this.s);
        }
    }

    static class ForwardReading
    implements Runnable {
        Reading s;
        ReadingListener client;

        ForwardReading(Reading s, ReadingListener client) {
            this.s = s;
            this.client = client;
        }

        @Override
        public void run() {
            this.client.notify(this.s);
        }
    }
}

