/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Reading {
    final String id;
    final double[] values;
    final int time;
    final Object rawData;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Reading(String id, double[] values) {
        this.id = id;
        this.values = values;
        this.rawData = null;
        this.time = 0;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Reading(String id, double[] values, String raw) {
        this.id = id;
        this.values = values;
        this.rawData = raw;
        this.time = 0;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Reading(String id, double[] values, int time) {
        this.id = id;
        this.values = values;
        this.rawData = null;
        this.time = time;
    }

    public Reading(Reading r) {
        this.id = r.getId();
        this.values = r.getValues();
        this.rawData = null;
        this.time = r.getTime();
    }

    public int getTime() {
        return this.time;
    }

    public String getId() {
        return this.id;
    }

    public int getNValues() {
        return this.values.length - 1;
    }

    public double getValue(int i) {
        return this.values[i];
    }

    public double[] getValues() {
        double[] retval = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            retval[i] = this.values[i];
        }
        return retval;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Reading id=").append(this.getId()).append(" values=");
        for (int i = 1; i <= this.getNValues(); ++i) {
            b.append(this.getValue(i)).append(i != this.getNValues() ? "," : " ");
        }
        return b.toString();
    }

    public Object getRawData() {
        return this.rawData;
    }
}

