/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class Region {
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"}, justification="internal state, not changeable from outside")
    GeneralPath path;
    final Point3d[] points;
    private static final Logger log = LoggerFactory.getLogger(Region.class);

    public Region(Point3d[] points) {
        this.initPath(points);
        if (points.length < 3) {
            log.error("Not enough points to define region");
        }
        this.points = Arrays.copyOf(points, points.length);
    }

    public Region(String s) {
        String[] pStrings = s.split(";");
        this.points = new Point3d[pStrings.length];
        for (int i = 0; i < this.points.length; ++i) {
            String coords = pStrings[i].substring(1, pStrings[i].length() - 1);
            String[] coord = coords.split(",");
            if (coord.length != 3) {
                log.error("need to have three coordinates in {}", (Object)pStrings[i]);
            }
            double x = Double.valueOf(coord[0]);
            double y = Double.valueOf(coord[1]);
            double z = Double.valueOf(coord[2]);
            this.points[i] = new Point3d(x, y, z);
        }
        this.initPath(this.points);
    }

    public Shape getPath() {
        return this.path;
    }

    void initPath(Point3d[] points) {
        if (points.length < 3) {
            log.error("Region needs at least three points to have non-zero area");
        }
        this.path = new GeneralPath();
        this.path.moveTo((float)points[0].x, (float)points[0].y);
        for (int i = 1; i < points.length; ++i) {
            this.path.lineTo((float)points[i].x, (float)points[i].y);
        }
        this.path.lineTo((float)points[0].x, (float)points[0].y);
    }

    public String toString() {
        StringBuilder retval = new StringBuilder("");
        for (int i = 0; i < this.points.length; ++i) {
            retval.append(String.format("(%f,%f,%f)", this.points[i].x, this.points[i].y, this.points[i].z));
            if (i == this.points.length - 1) continue;
            retval.append(";");
        }
        return retval.toString();
    }

    public boolean isInside(Point3d p) {
        return this.path.contains(p.x, p.y);
    }

    public boolean equals(Object ro) {
        if (ro == null || !(ro instanceof Region)) {
            return false;
        }
        try {
            Region r = (Region)ro;
            if (this.points.length != r.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].epsilonEquals((Tuple3d)r.points[i], 0.001)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        int code = 0;
        if (this.points.length >= 1) {
            code = 10000 * (int)this.points[0].x + 10000 * (int)this.points[0].y;
        }
        if (this.points.length >= 2) {
            code = code + 10000 * (int)this.points[1].x + 10000 * (int)this.points[1].y;
        }
        return code;
    }
}

